% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2sd.R
\name{r2sd}
\alias{r2sd}
\alias{r2sd_at}
\title{Scale a vector (or vectors) by two standard deviations}
\usage{
r2sd(x, na = TRUE)

r2sd_at(data, x)
}
\arguments{
\item{x}{a vector, likely in your data frame}

\item{na}{what to do with NAs in the vector. Defaults to TRUE (i.e. passes over the missing observations)}

\item{data}{a data frame}
}
\value{
The function returns a numeric vector rescaled with a mean of 0 and a
standard deviation of .5.
}
\description{
\code{r2sd} allows you to rescale a numeric vector such that the
ensuing output has a mean of 0 and a standard deviation of .5. \code{r2sd_at} is a wrapper for
\code{mutate_at} and \code{rename_at} from \pkg{dplyr}. It both rescales the supplied vectors to
new vectors and renames the vectors to each have a prefix of \code{z_}.
}
\details{
By default, `na.rm` is set to TRUE. If you have missing data, the function will just pass
over them.

Gelman (2008) argues that rescaling by two standard deviations puts regression inputs
on roughly the same scale no matter their original scale. This allows for some honest, if preliminary,
assessment of relative effect sizes from the regression output. This does that, but
without requiring the \code{rescale} function from \pkg{arm}.
I'm trying to reduce the packages on which my workflow relies.

Importantly, I tend to rescale only the ordinal and interval inputs and leave the binary inputs as 0/1.
So, my \code{r2sd} function doesn't have any of the fancier if-else statements that Gelman's \code{rescale}
function has.
}
\examples{

x <- rnorm(100)
r2sd(x)

r2sd_at(mtcars, c("mpg", "hp", "disp"))
}
\references{
Gelman, Andrew. 2008. "Scaling Regression Inputs by Dividing by Two Standard Deviations." \emph{Statistics in Medicine} 27: 2865--2873.
}
