% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd-mm_nhis.R
\docType{data}
\name{mm_nhis}
\alias{mm_nhis}
\title{Data from the 2009 National Health Interview Survey (NHIS)}
\format{
A data frame with 18790 observations on the following 10 variables.
\describe{
\item{\code{fml}}{is the respondent a woman?}
\item{\code{hi}}{a numeric vector for whether respondent has at least some health insurance}
\item{\code{hlth}}{a numeric vector for a health index, broadly understood}
\item{\code{nwhite}}{is the respondent not white?}
\item{\code{age}}{the respondent's age in years}
\item{\code{yedu}}{the respondent's total years of education}
\item{\code{famsize}}{the size of the respondent's family}
\item{\code{empl}}{is the respondent employed}
\item{\code{inc}}{the respondent's household/family income}
\item{\code{perweight}}{a numeric vector for weight}
}
}
\source{
National Health Interview Survey (2009).
}
\usage{
mm_nhis
}
\description{
These are data from the 2009 NHIS survey. People who have read
 \emph{Mastering 'Metrics} should recognize these data. They're
 featured prominently in that book and the authors' discussion of
 random assignment and experiments.
}
\details{
Data are already cleaned in a way that facilitates an easy
replication of Table 1.1 in \emph{Mastering 'Metrics}. Check
the book's website for more information.
}
\keyword{datasets}
