% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landscape-class.R
\name{landscape}
\alias{landscape}
\title{Create a landscape object.}
\usage{
landscape(population, suitability = NULL, carrying_capacity = NULL, ...)
}
\arguments{
\item{population}{a raster stack (grid cell-based) with one layer for each life
stage.}

\item{suitability}{an optional raster layer or stack (multiple layers) containing
habitat suitability values for all cells in a landscape. Note, using a raster
stack assumes that the user has provided a layer for each intended timestep
in a simulation.}

\item{carrying_capacity}{an optional raster layer specifying carrying capacity
values for all cells in a landscape or a function defining how carrying capacity
is determined by habitat suitability.}

\item{...}{named raster objects representing different aspects of the landscape
used to modify the landscape object in a simulation. Note, this is intended to
store objects that are accessed by dynamic functions and used to modify the
landscape in a simulation. Also, further arguments passed to or from other methods.}
}
\value{
An object of class \code{landscape}
}
\description{
A landscape object is used to store spatially-explicit information on population,
habitat suitability, carrying_capacity and miscellaneous landscape information.
}
\details{
A landscape object is modified in each timestep of a simulation. During a simulation,
population, habitat suitability or carrying capacity in a landscape object are changed 
based on dynamic functions selected or created by the user.
}
\examples{

# Example of setting up a landscape object.

\dontrun{
ls <- landscape(population = egk_pop, suitability = egk_hab, carrying_capacity = egk_k)

pd <- population_dynamics(change = growth(egk_mat))

simulation(landscape = ls, population_dynamics = pd, habitat_dynamics = NULL, timesteps = 20)
}
}
