% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.r
\name{stepaic}
\alias{stepaic}
\title{Stepwise forward variable selection based on the AIC criterion}
\usage{
stepaic(Data, standardize = TRUE)
}
\arguments{
\item{Data}{a data frame, as a first column should hava the response variable y}

\item{standardize}{Logical flag for x variable standardization, prior to fitting the model sequence.
Default is standardize=TRUE}
}
\value{
a list with the coefficients of the final model.
It also returns the in-sample AUC and the Brier score
}
\description{
It is a wrapper function over the step function in the buildin package stats
}
\examples{
set.seed(14)
beta    <- c(3, 2, -1.6, -4)
noise   <- 5
simData <- SimData(N=100, beta=beta, noise=noise, corr=FALSE)

stepaicfit <- stepaic(Data=simData)
stepaicfit
}
\seealso{
\code{\link[stats]{step}}
}

