% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEffects_Transaction.R
\name{getEffects_Transaction}
\alias{getEffects_Transaction}
\title{Get an overview of transaction effects for a specific transaction.}
\usage{
getEffects_Transaction(hash, cursor = NULL, limit = 10, order = "asc",
  data.table = TRUE)
}
\arguments{
\item{hash}{character - the transaction id.}

\item{cursor}{numeric - optional, a paging token - where to start from. Can also be "now".}

\item{limit}{numeric - optional, the number of records to return. Default is 10.}

\item{order}{character - optional, "asc" or "desc"}

\item{data.table}{boolean - if TRUE, a data.table is returned. If FALSE or NULL, a list is returned.}
}
\value{
data.table (by default) or list
}
\description{
Returns effect details for a specific transaction on the ledger. Converts the JSON response to a list.
}
\note{
https://www.stellar.org/developers/horizon/reference/endpoints/effects-for-transaction.html
}
\examples{
\donttest{getEffects_Transaction("SomeTxnHash")}
}
