% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/paths_summary_fuzzy.R
\name{paths_summary_fuzzy}
\alias{paths_summary_fuzzy}
\title{Summarize a fuzzy STCM dataset}
\usage{
paths_summary_fuzzy(data, case.ids, outcome, conditions,
 inter.func, sig.digits, size.warn)
}
\arguments{
\item{data}{a data frame}

\item{case.ids}{optional character vector containing variable names that identify cases}

\item{outcome}{a character string containing the name of the outcome variable}

\item{conditions}{an optional character vector containing the names of the causal factors}

\item{inter.func}{a function that combines the constituent values of an interaction}

\item{sig.digits}{number of significant digits for cutpoints}

\item{size.warn}{logical; if \code{TRUE}, prompts the user to authorize execution when number of causal paths >=1000}
}
\value{
Returns a named list with the following components:

\item{\code{n.fuzzy.paths.obs}}{a data frame containing the number and percent of possible paths observed for a given binary cutpoint}
\item{\code{fuzzy.paths.plot}}{a plot of the percent of possible paths observed across a range of binary cutpoints}
}
\description{
\code{paths_summary_fuzzy} provides descriptions of an STCM dataset related to cases
and causal paths.
}
\examples{
# Load data
data(hh)

# Run function
a<-paths_summary_fuzzy(data = hh, case.ids = "Country", outcome = "success", sig.digits = 1)

# Get results
a$n.fuzzy.paths.obs

# Get plot
a$fuzzy.paths.plot
}

