# contingency_table works

    Code
      select(df1, -expression)
    Output
      # A tibble: 1 x 11
        statistic    df p.value method                     effectsize        estimate
            <dbl> <int>   <dbl> <chr>                      <chr>                <dbl>
      1      8.74     2  0.0126 Pearson's Chi-squared test Cramer's V (adj.)    0.464
        conf.level conf.low conf.high conf.method conf.distribution
             <dbl>    <dbl>     <dbl> <chr>       <chr>            
      1       0.99        0         1 ncp         chisq            

---

    Code
      df1$expression[[1]]
    Output
      paste(chi["Pearson"]^2, "(", "2", ") = ", "8.74073", ", ", italic("p"), 
          " = ", "0.01265", ", ", widehat(italic("V"))["Cramer"], " = ", 
          "0.46431", ", CI"["99%"], " [", "0.00000", ", ", "1.00000", 
          "], ", italic("n")["obs"], " = ", "32")

---

    Code
      select(df2, -expression)
    Output
      # A tibble: 1 x 11
        statistic    df   p.value method                     effectsize       
            <dbl> <int>     <dbl> <chr>                      <chr>            
      1      457.     1 2.30e-101 Pearson's Chi-squared test Cramer's V (adj.)
        estimate conf.level conf.low conf.high conf.method conf.distribution
           <dbl>      <dbl>    <dbl>     <dbl> <chr>       <chr>            
      1    0.455       0.95    0.420         1 ncp         chisq            

---

    Code
      df2$expression[[1]]
    Output
      paste(chi["Pearson"]^2, "(", "1", ") = ", "456.87", ", ", italic("p"), 
          " = ", "2.3e-101", ", ", widehat(italic("V"))["Cramer"], 
          " = ", "0.46", ", CI"["95%"], " [", "0.42", ", ", "1.00", 
          "], ", italic("n")["obs"], " = ", "2,201")

---

    Code
      select(df3, -expression)
    Output
      # A tibble: 1 x 11
        statistic    df p.value method                     effectsize        estimate
            <dbl> <int>   <dbl> <chr>                      <chr>                <dbl>
      1      15.8    15   0.399 Pearson's Chi-squared test Cramer's V (adj.)   0.0558
        conf.level conf.low conf.high conf.method conf.distribution
             <dbl>    <dbl>     <dbl> <chr>       <chr>            
      1       0.99        0         1 ncp         chisq            

---

    Code
      df3$expression[[1]]
    Output
      paste(chi["Pearson"]^2, "(", "15", ") = ", "15.75", ", ", italic("p"), 
          " = ", "0.399", ", ", widehat(italic("V"))["Cramer"], " = ", 
          "0.06", ", CI"["99%"], " [", "0.00", ", ", "1.00", "], ", 
          italic("n")["obs"], " = ", "52")

# paired contingency_table works 

    Code
      select(df1, -expression)
    Output
      # A tibble: 1 x 10
        statistic    df  p.value method                     effectsize estimate
            <dbl> <dbl>    <dbl> <chr>                      <chr>         <dbl>
      1      13.3     1 0.000261 McNemar's Chi-squared test Cohen's g     0.333
        conf.level conf.low conf.high conf.method
             <dbl>    <dbl>     <dbl> <chr>      
      1       0.95    0.164     0.427 binomial   

---

    Code
      df1$expression[[1]]
    Output
      paste(chi["McNemar"]^2, "(", "1", ") = ", "13.33333", ", ", italic("p"), 
          " = ", "2.6073e-04", ", ", widehat(italic("g"))["Cohen"], 
          " = ", "0.33333", ", CI"["95%"], " [", "0.16436", ", ", "0.42663", 
          "], ", italic("n")["pairs"], " = ", "100")

---

    Code
      select(df2, -expression)
    Output
      # A tibble: 1 x 10
        statistic    df  p.value method                     effectsize estimate
            <dbl> <dbl>    <dbl> <chr>                      <chr>         <dbl>
      1      13.3     1 0.000261 McNemar's Chi-squared test Cohen's g     0.333
        conf.level conf.low conf.high conf.method
             <dbl>    <dbl>     <dbl> <chr>      
      1        0.9    0.195     0.416 binomial   

---

    Code
      df2$expression[[1]]
    Output
      paste(chi["McNemar"]^2, "(", "1", ") = ", "13.333", ", ", italic("p"), 
          " = ", "2.61e-04", ", ", widehat(italic("g"))["Cohen"], " = ", 
          "0.333", ", CI"["90%"], " [", "0.195", ", ", "0.416", "], ", 
          italic("n")["pairs"], " = ", "95")

# Goodness of Fit contingency_table works without counts

    Code
      select(df1, -expression)
    Output
      # A tibble: 1 x 11
        statistic    df p.value method                                   effectsize 
            <dbl> <dbl>   <dbl> <chr>                                    <chr>      
      1      1.12     1   0.289 Chi-squared test for given probabilities Pearson's C
        estimate conf.level conf.low conf.high conf.method conf.distribution
           <dbl>      <dbl>    <dbl>     <dbl> <chr>       <chr>            
      1    0.184       0.99        0         1 ncp         chisq            

---

    Code
      df1$expression[[1]]
    Output
      paste(chi["gof"]^2, "(", "1", ") = ", "1.12500", ", ", italic("p"), 
          " = ", "0.28884", ", ", widehat(italic("C"))["Pearson"], 
          " = ", "0.18429", ", CI"["99%"], " [", "0.00000", ", ", "1.00000", 
          "], ", italic("n")["obs"], " = ", "32")

---

    Code
      select(df2, -expression)
    Output
      # A tibble: 1 x 11
        statistic    df   p.value method                                   effectsize 
            <dbl> <dbl>     <dbl> <chr>                                    <chr>      
      1      722.     1 3.92e-159 Chi-squared test for given probabilities Pearson's C
        estimate conf.level conf.low conf.high conf.method conf.distribution
           <dbl>      <dbl>    <dbl>     <dbl> <chr>       <chr>            
      1    0.497       0.95    0.474         1 ncp         chisq            

---

    Code
      df2$expression[[1]]
    Output
      paste(chi["gof"]^2, "(", "1", ") = ", "722.45", ", ", italic("p"), 
          " = ", "3.92e-159", ", ", widehat(italic("C"))["Pearson"], 
          " = ", "0.50", ", CI"["95%"], " [", "0.47", ", ", "1.00", 
          "], ", italic("n")["obs"], " = ", "2,201")

---

    Code
      select(df3, -expression)
    Output
      # A tibble: 1 x 11
        statistic    df     p.value method                                  
            <dbl> <dbl>       <dbl> <chr>                                   
      1      33.8     3 0.000000223 Chi-squared test for given probabilities
        effectsize  estimate conf.level conf.low conf.high conf.method
        <chr>          <dbl>      <dbl>    <dbl>     <dbl> <chr>      
      1 Pearson's C    0.555       0.95    0.413         1 ncp        
        conf.distribution
        <chr>            
      1 chisq            

---

    Code
      df3$expression[[1]]
    Output
      paste(chi["gof"]^2, "(", "3", ") = ", "33.76", ", ", italic("p"), 
          " = ", "2.23e-07", ", ", widehat(italic("C"))["Pearson"], 
          " = ", "0.55", ", CI"["95%"], " [", "0.41", ", ", "1.00", 
          "], ", italic("n")["obs"], " = ", "76")

# bayes factor (proportion test)

    Code
      expr_text$expression[[1]]
    Output
      atop(displaystyle("duh"), expr = paste("log"["e"] * "(BF"["01"] * 
          ") = " * "0.55" * ", ", italic("a")["Gunel-Dickey"] * " = " * 
          "10.00"))

# bayes factor (contingency tab)

    Code
      list(expr_text1$expression[[1]], expr_text2$expression[[1]], expr_text3$
        expression[[1]])
    Output
      [[1]]
      paste("log"["e"] * "(BF"["01"] * ") = " * "-3.335" * ", ", widehat(italic("V"))["Cramer"]^"posterior" * 
          " = " * "0.479" * ", ", "CI"["89%"]^"HDI" * " [" * "0.285" * 
          ", " * "0.692" * "], ", italic("a")["Gunel-Dickey"] * " = " * 
          "1.000")
      
      [[2]]
      paste("log"["e"] * "(BF"["01"] * ") = " * "-214.255" * ", ", 
          widehat(italic("V"))["Cramer"]^"posterior" * " = " * "0.455" * 
              ", ", "CI"["99%"]^"HDI" * " [" * "0.402" * ", " * "0.508" * 
              "], ", italic("a")["Gunel-Dickey"] * " = " * "1.000")
      
      [[3]]
      paste("log"["e"] * "(BF"["01"] * ") = " * "-213.873" * ", ", 
          widehat(italic("V"))["Cramer"]^"posterior" * " = " * "0.454" * 
              ", ", "CI"["95%"]^"HDI" * " [" * "0.417" * ", " * "0.495" * 
              "], ", italic("a")["Gunel-Dickey"] * " = " * "1.500")
      

