% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneway_anova.R
\name{expr_oneway_anova}
\alias{expr_oneway_anova}
\title{Expression and dataframe for one-way ANOVA}
\usage{
expr_oneway_anova(
  data,
  x,
  y,
  subject.id = NULL,
  type = "parametric",
  paired = FALSE,
  k = 2L,
  conf.level = 0.95,
  effsize.type = "omega",
  var.equal = FALSE,
  bf.prior = 0.707,
  tr = 0.1,
  nboot = 100,
  top.text = NULL,
  output = "expression",
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{subject.id}{In case of repeated measures design (\code{paired = TRUE},
i.e.), this argument specifies the subject or repeated measures id. Note
that if this argument is \code{NULL} (which is the default), the function
assumes that the data has already been sorted by such an id by the user and
creates an internal identifier. So if your data is \strong{not} sorted and you
leave this argument unspecified, the results can be inaccurate.}

\item{type}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}).Corresponding abbreviations are also accepted:
\code{"p"} (for parametric), \code{"np"} (nonparametric), \code{"r"} (robust), or
\code{"bf"}resp.}

\item{paired}{Logical that decides whether the experimental design is
repeated measures/within-subjects or between-subjects. The default is
\code{FALSE}.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} confidence/credible intervals (\code{0.95}).}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"eta"} (partial eta-squared) or \code{"omega"} (partial
omega-squared).}

\item{var.equal}{a logical variable indicating whether to treat the
    two variances as being equal. If \code{TRUE} then the pooled
    variance is used to estimate the variance otherwise the Welch
    (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors.}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. If you
get error stating "Standard error cannot be computed because of Winsorized
variance of 0 (e.g., due to ties). Try to decrease the trimming level.",
try to play around with the value of \code{tr}, which is by default set to
\code{0.1}. Lowering the value might help.}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{top.text}{Text to display on top of the Bayes Factor message. This is
mostly relevant in the context of \code{ggstatsplot} functions.}

\item{output}{If \code{"expression"}, will return expression with statistical
details, while \code{"dataframe"} will return a dataframe containing the
results.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
For more details, see-
\url{https://indrajeetpatil.github.io/statsExpressions/articles/stats_details.html}
}
\description{
Expression and dataframe for one-way ANOVA
}
\examples{
\donttest{
# for reproducibility
set.seed(123)
library(statsExpressions)

# ----------------------- parametric -------------------------------------

# between-subjects
expr_oneway_anova(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem
)

# within-subjects design
expr_oneway_anova(
  data = iris_long,
  x = condition,
  y = value,
  subject.id = id,
  paired = TRUE,
  output = "dataframe"
)

# ----------------------- non-parametric ----------------------------------

# between-subjects
expr_oneway_anova(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem,
  type = "np"
)

# within-subjects design
expr_oneway_anova(
  data = iris_long,
  x = condition,
  y = value,
  subject.id = id,
  paired = TRUE,
  type = "np",
  output = "dataframe"
)

# ----------------------- robust -------------------------------------

# between-subjects
expr_oneway_anova(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem,
  type = "r"
)

# within-subjects design
expr_oneway_anova(
  data = iris_long,
  x = condition,
  y = value,
  subject.id = id,
  paired = TRUE,
  type = "r",
  output = "dataframe"
)

# ----------------------- Bayesian -------------------------------------

# between-subjects
expr_oneway_anova(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem,
  type = "bayes"
)

# within-subjects design
# needs `BayesFactor 0.9.12-4.3` or above
if (utils::packageVersion("BayesFactor") >= package_version("0.9.12-4.3")) {
  expr_oneway_anova(
    data = iris_long,
    x = condition,
    y = value,
    subject.id = id,
    paired = TRUE,
    type = "bayes",
    output = "dataframe"
  )
}
}
}
