% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_bf_tests.R
\name{bf_contingency_tab}
\alias{bf_contingency_tab}
\alias{bf_onesample_proptest}
\title{Bayesian contingency table analysis}
\usage{
bf_contingency_tab(
  data,
  x,
  y = NULL,
  counts = NULL,
  ratio = NULL,
  sampling.plan = "indepMulti",
  fixed.margin = "rows",
  prior.concentration = 1,
  caption = NULL,
  output = "null",
  k = 2,
  ...
)

bf_onesample_proptest(
  data,
  x,
  y = NULL,
  counts = NULL,
  ratio = NULL,
  sampling.plan = "indepMulti",
  fixed.margin = "rows",
  prior.concentration = 1,
  caption = NULL,
  output = "null",
  k = 2,
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{an m by n matrix of counts (integers m,n > 1)}

\item{y}{The variable to use as the \strong{columns} in the contingency
table. Default is \code{NULL}. If \code{NULL}, one-sample proportion test (a goodness
of fit test) will be run for the \code{main} variable. Otherwise an appropriate
association test will be run.}

\item{counts}{A string naming a variable in data containing counts, or \code{NULL}
if each row represents a single observation (Default).}

\item{ratio}{A vector of proportions: the expected proportions for the
proportion test (should sum to 1). Default is \code{NULL}, which means the null
is equal theoretical proportions across the levels of the nominal variable.
This means if there are two levels this will be \code{ratio = c(0.5,0.5)} or if
there are four levels this will be \code{ratio = c(0.25,0.25,0.25,0.25)}, etc.}

\item{sampling.plan}{Character describing the sampling plan. Possible options
are \code{"indepMulti"} (independent multinomial; default), \code{"poisson"},
\code{"jointMulti"} (joint multinomial), \code{"hypergeom"} (hypergeometric). For
more, see \code{?BayesFactor::contingencyTableBF()}.}

\item{fixed.margin}{For the independent multinomial sampling plan, which
margin is fixed (\code{"rows"} or \code{"cols"}). Defaults to \code{"rows"}.}

\item{prior.concentration}{Specifies the prior concentration parameter, set
to \code{1} by default. It indexes the expected deviation from the null
hypothesis under the alternative, and corresponds to Gunel and Dickey's
(1974) \code{"a"} parameter.}

\item{caption}{Text to display as caption (will be displayed on top of the
Bayes Factor caption/message).}

\item{output}{Can either be \code{"null"} (or \code{"caption"} or \code{"H0"} or \code{"h0"}),
which will return expression with evidence in favor of the null hypothesis,
or \code{"alternative"} (or \code{"title"} or \code{"H1"} or \code{"h1"}), which will return
expression with evidence in favor of the alternative hypothesis, or
\code{"results"}, which will return a dataframe with results all the details).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{...}{further arguments to be passed to or from methods.}
}
\description{
Bayesian contingency table analysis
}
\note{
Bayes Factor for goodness of fit test is based on gist provided by
Richard Morey:
\url{https://gist.github.com/richarddmorey/a4cd3a2051f373db917550d67131dba4}.
}
\examples{

\donttest{
# ------------------ association tests --------------------------------

# for reproducibility
set.seed(123)
library(statsExpressions)

# to get caption (in favor of null)
bf_contingency_tab(
  data = mtcars,
  x = am,
  y = cyl,
  fixed.margin = "cols"
)

# to get caption (in favor of alternative)
bf_contingency_tab(
  data = mtcars,
  x = am,
  y = cyl,
  fixed.margin = "rows",
  output = "alternative"
)

# to see results
bf_contingency_tab(
  data = mtcars,
  x = am,
  y = cyl,
  sampling.plan = "jointMulti",
  fixed.margin = "rows",
  prior.concentration = 1
)

# ------------------ goodness of fit tests --------------------------------

bf_contingency_tab(
  data = mtcars,
  x = am,
  prior.concentration = 10
)
}
}
\seealso{
\code{\link{bf_corr_test}}, \code{\link{bf_oneway_anova}},
\code{\link{bf_ttest}}
}
\author{
\href{https://github.com/IndrajeetPatil}{Indrajeet Patil}
}
