% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{size.ci.phi}
\alias{size.ci.phi}
\title{Sample size for phi correlation confidence interval}
\usage{
size.ci.phi(alpha, p1, p2, phi, w)
}
\arguments{
\item{alpha}{alpha level for 1 - alpha confidence}

\item{p1}{planning value for row 1 marginal proportion}

\item{p2}{planning value for column 1 marginal proportion}

\item{phi}{planning value for phi correlation}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a phi correlation with desired
confidence interval precision. Set the phi correlation planning value to the
smallest absolute value within a plausible range for a conservatively large
sample size.
}
\examples{
size.ci.phi(.05, .7, .8, .35, .2)

# Should return:
#  Sample size
#          416


}
