% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{test.kurtosis}
\alias{test.kurtosis}
\title{Computes p-value for test of excess kurtosis}
\usage{
test.kurtosis(y)
}
\arguments{
\item{y}{vector of quantitative scores}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Kurtosis - estimate of kurtosis coefficient
\item Excess - estimate of excess kurtosis (kurtosis - 3)
\item p - Monte Carlo two-sided p-value
}
}
\description{
Computes a Monte Carlo p-value (250,000 replications) for the null
hypothesis that the sample data come from a normal distribution. If the
p-value is small (e.g., less than .05) and excess kurtosis is positive,
then the normality assumption can be rejected due to leptokurtosis. If the
p-value is small (e.g., less than .05) and excess kurtosis is negative,
then the normality assumption can be rejected due to platykurtosis.
}
\examples{
y <- c(30, 20, 15, 10, 10, 60, 20, 25, 20, 30, 10, 5, 50, 40, 95)
test.kurtosis(y)

# Should return:
# Kurtosis  Excess      p
#   4.8149  1.8149 0.0385 


}
