% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.prop.fpc}
\alias{ci.prop.fpc}
\title{Confidence interval for a proportion with a finite population
correction}
\usage{
ci.prop.fpc(alpha, f, n, N)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f}{number of participants who have the attribute}

\item{n}{sample size}

\item{N}{population size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - adjusted estimate of proportion
\item SE - adjusted standard error with fpc
\item LL - lower limit of the confidence interval with fpc
\item UL - upper limit of the confidence interval with fpc
}
}
\description{
Computes an adjusted Wald interval for a population proportion with a
finite population correction (fpc). This confidence interval is useful
when the sample size is not a small fraction of the population size.
}
\examples{
ci.prop.fpc(.05, 12, 100, 400)

# Should return:
#   Estimate         SE         LL        UL
#  0.1346154  0.0290208 0.07773565 0.1914951


}
