% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.sign1}
\alias{ci.sign1}
\title{Confidence interval for the parameter of the one-sample sign test}
\usage{
ci.sign1(alpha, y, h)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y}{vector of y scores}

\item{h}{null hypothesis value for population median}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - adjusted estimate of proportion
\item SE - adjusted standard error
\item LL - lower limit of adjusted Wald confidence interval
\item UL - upper limit of adjusted Wald confidence interval
}
}
\description{
Computes adjusted Wald interval for the population proportion of
quantitative scores that are greater than the null hypothesis value
of the population median in a one-sample sign test.
}
\examples{
y <- c(30, 20, 15, 10, 10, 60, 20, 25, 20, 30, 10, 5, 50, 40, 20, 10,
        0, 20, 50)
ci.sign1(.05, y, 9)

# Should return:
# Estimate        SE        LL        UL
# 0.826087 0.0790342 0.6711828 0.9809911


}
\references{
Agresti, A, & Coull, BA (1998) Approximate is better than “exact” for
interval estimation of binomial proportions. American Statistician, 52,
119–126. doi: 10.1080/00031305.1998.10480550
}
