% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_size.R
\name{effect_size}
\alias{effect_size}
\title{Calculate effect sizes in a model}
\usage{
effect_size(model, formula, step = NULL, bootstrap = FALSE, to = step,
  data = NULL, at = NULL, ...)
}
\arguments{
\item{model}{the model from which the effect size is to be calculated}

\item{formula}{a formula whose right-hand side is the variable with respect
to which the effect size is to be calculated.}

\item{step}{the numerical stepsize for the change var, or a comparison category
for a categorical change var. This will be either a character string or a number,
depending on the type of variable specified in the formula.}

\item{bootstrap}{If \code{TRUE}, calculate a standard error using bootstrapping. Alternatively, you can 
specify the number of bootstrap replications (default:100).}

\item{to}{a synonym for step. (In English, "to" is more appropriate for a 
categorical input, "step" for a quantitative. But you can use either.)}

\item{data}{Specifies exactly the cases at which you want to calculate the effect size.
Unlike \code{...} or \code{at}, no new combinations will be created.}

\item{at}{similar to \code{...} but expects a list or dataframe of the values you want to set.
Like \code{...}, all combinations of the values specified will be used as inputs.}

\item{...}{additional arguments for evaluation levels of explanatory 
variables or to be passed to  \code{predict()}. For instance, for a glm, perhaps you
want \code{type = "response"}.}
}
\description{
Like a derivative or finite-difference
}
\details{
When you want to force or restrict the effect size calculation to specific values for 
explanatory variables, list those variables and levels as a vector in ...
For example, \code{educ = c(10, 12, 16)} will cause the effect size to be calculated
at each of those three levels of education. Any variables whose levels are not specified in 
... will have values selected automatically.
}
\examples{
mod1 <- lm(wage ~ age * sex * educ + sector, data = mosaicData::CPS85)
effect_size(mod1, ~ sex)
effect_size(mod1, ~ sector)
effect_size(mod1, ~ age, sex = "M", educ = c(10, 12, 16), age = c(30, 40))
effect_size(mod1, ~ age, sex = "F", age = 34, step = 1)
effect_size(mod1, ~ sex, age = 35, sex = "M", to = "F" )
}

