% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createAMMI.R
\name{AMMI}
\alias{AMMI}
\alias{createAMMI}
\title{S3 class AMMI}
\usage{
createAMMI(
  envScores,
  genoScores,
  importance,
  anova,
  fitted,
  trait,
  envMean,
  genoMean,
  overallMean,
  dat,
  GGE,
  byYear
)
}
\arguments{
\item{envScores}{A matrix containing environmental scores.}

\item{genoScores}{A matrix containing genotypic scores.}

\item{importance}{A data.frame containing the importance of the principal
components.}

\item{anova}{A data.frame containing anova scores of the AMMI analysis.}

\item{fitted}{A matrix containing fitted values from the AMMI model.}

\item{trait}{A character string indicating the analyzed trait.}

\item{envMean}{A numerical vector containing the environmental means.}

\item{genoMean}{A numerical vector containing the genotypic means.}

\item{overallMean}{A numerical value containing the overall mean.}

\item{GGE}{Has a GGE analysis been performed?}

\item{byYear}{Has the analysis been performed by year?}
}
\description{
Function for creating objects of S3 class AMMI.\cr
\code{\link{print}}, \code{\link{summary}}, \code{\link{plot}} and
\code{\link{report}} methods are available.
}
\seealso{
\code{\link{plot.AMMI}}, \code{\link{report.AMMI}}
}
\keyword{internal}
