% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createGWAS.R
\name{plot.GWAS}
\alias{plot.GWAS}
\title{Plot function for the class \code{GWAS}}
\usage{
\method{plot}{GWAS}(
  x,
  ...,
  plotType = c("manhattan", "qq", "qtl"),
  trial = NULL,
  trait = NULL,
  output = TRUE
)
}
\arguments{
\item{x}{An object of class \code{GWAS}.}

\item{...}{further arguments to be passed on to the actual plotting
functions.}

\item{plotType}{A character string indicating the type of plot to be made.
One of "manhattan", "qq" and "qtl".}

\item{trial}{A character string or numeric index indicating for which
trial the plot should be made. If \code{x} only contains results for
one trial, \code{trial} may be \code{NULL}.}

\item{trait}{A character string indicating for which trait the results
should be plotted. For \code{type} "qtl" all traits are plotted. If \code{x}
only contains results for one trait, \code{trait} may be \code{NULL}.}

\item{output}{Should the plot be output to the current device? If
\code{FALSE}, only a list of ggplot objects is invisibly returned.}
}
\description{
Creates a plot of an object of S3 class \code{GWAS}. The following types of
plot can be made:
\itemize{
\item{a manhattan plot, i.e. a plot of LOD-scores per SNP}
\item{a QQ plot of observed LOD-scores versus expected LOD-scores}
\item{a qtl plot of effect sizes and directions for multiple traits}
}
Manhattan plots and QQ plots are made for a single trait which
should be indicated using the parameter \code{trait}. If the analysis was
done for only one trait, it is detected automatically. The qtl plot will plot
all traits analyzed.\cr
See details for a detailed description of the plots and the plot options
specific to the different plots.
}
\section{Manhattan Plot}{

A LOD-profile of all marker positions and corresponding LOD-scores is
plotted. Significant markers are highlighted with red dots. By default these
are taken from the result of the GWAS analysis however the LOD-threshold for
significant parameters may be modified using the parameter \code{yThr}. The
threshold is plotted as a horizontal line. If there are previously known
marker effect, false positives and true negatives can also be marked.\cr
Extra parameter options:
\describe{
\item{\code{xLab}}{A character string, the x-axis label. Default =
\code{"Chromosomes"}}
\item{\code{yLab}}{A character string, the y-axis label. Default =
\code{-log10(p)}}
\item{\code{effects}}{A character vector, indicating which SNPs correspond
to a real (known) effect. Used for determining true/false positives and
false negatives. True positives are colored green, false positives orange and
false negatives yellow.}
\item{\code{colPalette}}{A color palette used for plotting. Default
coloring is done by chromosome, using black and grey.}
\item{\code{yThr}}{A numerical value for the LOD-threshold. The value from
the GWAS analysis is used as default.}
\item{\code{signLwd}}{A numerical value giving the thickness of the
points that are false/true positives/negatives. Default = 0.6}
\item{\code{lod}}{A positive numerical value. For the SNPs with a LOD-value
below this value, only 5\% is plotted. The chance of a SNP being plotted is
proportional to its LOD-score. This option can be useful when plotting a
large number of SNPs. The 5\% of SNPs plotted is selected randomly. For 
reproducible results use set.seed before calling the function.}
\item{\code{chr}}{A vector of chromosomes to be plotted. By default, all
chromosomes are plotted. Using this option allows restricting the plot to a
subset of chromosomes.}
}
}

\section{QQ-Plot}{

From the LOD-scores calculated in the GWAS analysis, a QQ-plot is generated 
with observed LOD-scores versus expected LOD-scores. Code is adapted from
Segura et al. (2012).
}

\section{QTL Plot}{

A plot of effect sizes for the significant SNPs found in the GWAS analysis
is created. Each horizontal line contains QTLs of one trait,
phenotypic trait or trial. Optionally, vertical white lines can indicate
chromosome subdivision, genes of interest, known QTL, etc. Circle diameters
are proportional to the absolute value of allelic effect. Colors indicate the
direction of the effect: green when the allele increases the trait value,
and blue when it decreases the value.\cr
Extra parameter options:
\describe{
\item{\code{normalize}}{Should the snpEffect be normalized? Default =
\code{FALSE}}
\item{\code{sortData}}{Should the data be sorted before plotting? Either
\code{FALSE}, if no sorting should be done, or a character string indicating
the data column to use for sorting. This should be a numerical column.
Default = \code{FALSE}}
\item{\code{binPositions}}{An optional data.frame containing at leasts two
columns, chr(omosome) and pos(ition). Vertical lines are plotted at those
positions. Default = \code{NULL}}
\item{\code{printVertGrid}}{Should default vertical grid lines be plotted.
Default = \code{TRUE}}
\item{\code{yLab}}{A character string, the y-axis label. Default =
\code{"Traits"}}
\item{\code{yThr}}{A numerical value for the LOD-threshold. The value from
the GWAS analysis is used as default.}
\item{\code{chr}}{A vector of chromosomes to be plotted. By default all
chromosomes are plotted. Using this option this can be restricted to a
subset of chromosomes.}
\item{\code{exportPptx}}{Should the plot be exported to a .pptx file?
Default = \code{FALSE}}
\item{\code{pptxName}}{A character string, the name of the .pptx file to
which the plot is exported. Ignored if exportPptx = \code{FALSE}.}
}
}

\references{
Millet et al. (2016) Genome-wide analysis of yield in Europe:
Allelic effects vary with drought and heat scenarios. Plant Physiology,
October 2016, Vol. 172, p. 749–764

Segura et al. (2012) An efficient multi-locus mixed-model
approach for genome-wide association studies in structured populations.
Nature Genetics, June 2012, Vol. 44, p. 825–830.
}
