load(file = "testdata.rda")

### Test runSingleTraitGwas with single kinship.

stg0 <- runSingleTraitGwas(gData = gDataTest, trials = 1)
stg1 <- runSingleTraitGwas(gData = gDataTest)
result1 <- runSingleTraitGwas(gData = gDataTest, trials = 1,
                              covar = "V1")[["GWAResult"]]
result1a <- runSingleTraitGwas(gData = gDataTest, traits = 2:6, trials = 1, 
                               covar = "V1")[["GWAResult"]]
result1b <- runSingleTraitGwas(gData = gDataTest, trials = 1,
                               covar = 1)[["GWAResult"]]
result2 <- runSingleTraitGwas(gData = gDataTest, trials = 1,
                              snpCov = "M2")[["GWAResult"]]
result3 <- runSingleTraitGwas(gData = gDataTest, trials = 1, covar = "V1",
                              snpCov = "M2")[["GWAResult"]]

## Check output structure.

expect_true(inherits(stg0, "GWAS"))
expect_equal(length(stg0), 5)
expect_equal(names(stg0), 
             c("GWAResult", "signSnp", "kinship", "thr", "GWASInfo"))
expect_equal(names(stg0[["GWASInfo"]]), 
             c("call", "remlAlgo", "thrType", "MAF", "GLSMethod", "varComp", 
               "genomicControl", "inflationFactor"))
expect_equal(length(stg0[["GWASInfo"]][["varComp"]][["ph1"]]), 5)
expect_true(inherits(stg0[["GWAResult"]], "list"))
expect_equal(length(stg0[["GWAResult"]]), 1)
expect_equal(names(stg0[["GWAResult"]]), "ph1")
expect_equal(length(stg1[["GWAResult"]]), 2)
expect_equal(names(stg1[["GWAResult"]]), c("ph1", "ph2"))

## Check p-Values

expect_equal(stg0[["GWAResult"]][["ph1"]][["pValue"]],
             c(0.556565207591542, 0.644409912847098, 0.815046103437094, 
               0.46416067677484, 0.307927840927776, 0.937588447652476,
               0.861424566054406, 0.64220617802571, 0.487859956237248,
               0.673232138421906, 0.552144063962775, 0.395714586737013, 
               0.832011110721433, 0.156889391235401, 0.253195176015333))
expect_equal(result1[["ph1"]][["pValue"]],
             c(0.351340586556164, 0.805121913672965, 0.97710572208884, 
               0.465199071828829, 0.32068791201796, 0.93835429411708,
               0.706887641093648, 0.728625579117767, 0.593806335086952,
               0.771670607342803, 0.489323081632407, 0.473509357066004, 
               0.871195025941687, 0.151626281146346, 0.233293824250749))
expect_equal(result2[["ph1"]][["pValue"]],
             c(0.601870706247044, 0.639608839221507, 0.879702684738528,
               0.528671908918732, 0.307927840927776, 0.805725551506335,
               0.827794265956364, 0.620674116521037, 0.579960510641916, 
               0.729405950213325, 0.552144063962774, 0.354221370612768, 
               0.934748044050838, 0.156889391235401, 0.328324199598967))
expect_equal(result3[["ph1"]][["pValue"]],
             c(0.407453651106354, 0.805121913672964, 0.964222347313319, 
               0.605576314394518, 0.320687912017961, 0.878249328147975, 
               0.735648828647385, 0.715294618992726, 0.652238864565491,
               0.893223912521159, 0.489323081632408, 0.457210861098801, 
               0.880519035238243, 0.151626281146346, 0.239301792260896))

## Check effects.

expect_equal(stg0[["GWAResult"]][["ph1"]][["effect"]],
             c(0.281196961557953, 0.270787659832638, -0.183827818510987, 
               -0.424623375012714, -0.712404445545492, -0.0754950435841936, 
               -0.121512913552812, -0.387037147361331, 0.760346967579727,
               0.177147797855602, 0.30408544635742, 0.572138780492293, 
               -0.156479414190887, -1.19930737632641, 1.32017648576984))
expect_equal(result1[["ph1"]][["effect"]],
             c(0.478643894550101, 0.156154597676827, 0.0247115254274738, 
               -0.484776962765978, -0.774132902165756, -0.0849665260154638,
               -0.29606625493789, -0.320961580513548, 0.6644727086835,
               0.138940358049405, 0.389553570358166, 0.547438870570076, 
               -0.137123618369648, -1.34196336062861, 1.55024604899299))
expect_equal(result2[["ph1"]][["effect"]],
             c(0.265287119537725, 0.274992779365586, -0.128016335697819,
               -0.369104717582792, -0.71240444554548, -0.240481834434491,
               -0.159371598035534, -0.415486560755866, 0.661357311094297,
               0.1534068496046, 0.304085446357424, 0.657987591567463, 
               -0.0571392499051401, -1.19930737632643, 1.08377527208679))
expect_equal(result3[["ph1"]][["effect"]],
             c(0.473146507899702, 0.15615459767689, 0.0419019448563874,
               -0.357345442796037, -0.774132902165716, -0.169946796542321,
               -0.290281388459914, -0.339538772577021, 0.611810266543856,
               0.0692437953496002, 0.38955357035814, 0.593439913315101, 
               0.121092108320429, -1.34196336062862, 1.4138231687998))

## Check values for traits containing NAs.

expect_equal(stg1[["GWAResult"]][["ph2"]][["pValue"]],
             c(0.535866686599578, 0.738175077654468, NA, 0.862874874084195, 
               0.707996660593566, 0.814639480900727, 0.940553316495392, 
               0.705694066841014, 0.446919390703314, 0.894606032126416, 
               0.511413255485449, 0.457037891963561, 0.966898351313243, 
               0.253600829295148, 0.782993491205565))
expect_equal(stg1[["GWAResult"]][["ph2"]][["effect"]],
             c(0.384318156764552, 0.234891575473521, NA, 0.0992876321027796, 
               0.313594562157908, -0.197059831391177, -0.0567532981847109, 
               -0.328320224241702, 0.847022493639187, 0.0555585062439554, 
               -0.3325198897839, 0.285348088200379, -0.0221226243845664, 
               -0.810848162781112, -0.119937375119302))

## Check that specifying traits by number functions correctly.
expect_equal(result1, result1a)

## Check that specifying covar by number functions correctly.
expect_equal(result1, result1b)

### Test runSingleTraitGwas with chromosome specific kinship.

stgM0 <- runSingleTraitGwas(gData = gDataTest, trials = 1, GLSMethod = "multi")
stgM1 <- runSingleTraitGwas(gData = gDataTest, GLSMethod = "multi")
resultM1 <- runSingleTraitGwas(gData = gDataTest, trials = 1, 
                               GLSMethod = "multi", covar = "V1")[["GWAResult"]]
resultM2 <- runSingleTraitGwas(gData = gDataTest, trials = 1, 
                               GLSMethod = "multi", snpCov = "M2")[["GWAResult"]]
resultM3 <- runSingleTraitGwas(gData = gDataTest, trials = 1, covar = "V1",
                               GLSMethod = "multi", snpCov = "M2")[["GWAResult"]]

## Check output structure.

expect_true(inherits(stgM0, "GWAS"))
expect_equal(length(stgM0), 5)
expect_equal(names(stgM0), 
             c("GWAResult", "signSnp", "kinship", "thr", "GWASInfo"))
expect_equal(names(stgM0[["GWASInfo"]]), 
             c("call", "remlAlgo", "thrType", "MAF", "GLSMethod", "varComp", 
               "genomicControl", "inflationFactor"))
expect_true(inherits(stgM0[["kinship"]], "list"))
expect_equal(length(stgM0[["kinship"]]), 2)
expect_true(inherits(stgM0[["kinship"]][[1]], "matrix"))
expect_equal(length(stgM0[["GWASInfo"]][["varComp"]][["ph1"]]), 5)
expect_equal(length(stgM0[["GWASInfo"]][["varComp"]][["ph1"]][[1]]), 2)
expect_true(inherits(stgM0[["GWAResult"]], "list"))
expect_equal(length(stgM0[["GWAResult"]]), 1)
expect_equal(names(stgM0[["GWAResult"]]), "ph1")
expect_equal(length(stgM1[["GWAResult"]]), 2)
expect_equal(names(stgM1[["GWAResult"]]), c("ph1", "ph2"))
expect_equal(stgM0[["GWASInfo"]][["GLSMethod"]] , "multi")

## Check p-Values

expect_equal(stgM0[["GWAResult"]][["ph1"]][["pValue"]],
             c(0.549793032076325, 0.639590925157073, 0.81364710410037, 
               0.464159700525685, 0.307927076333321, 0.937623436570631,
               0.780163671423179, 0.620664930419729, 0.508541856742733,
               0.67326825465673, 0.552141475908806, 0.395707693092344, 
               0.700166404881619, 0.164159205250983, 0.253196164520487))
expect_equal(resultM1[["ph1"]][["pValue"]],
             c(0.351320794199973, 0.805105670937093, 0.977133280568928, 
               0.465201425677315, 0.320687607161297, 0.938385757230259,
               0.66230329353743, 0.715282683139242, 0.608086094782391,
               0.771699427124505, 0.489324007039572, 0.473501017024746, 
               0.732664133437509, 0.144328262539473, 0.233294048945401))
expect_equal(resultM2[["ph1"]][["pValue"]],
             c(0.601840413030708, 0.639590925157077, 0.879677417342201, 
               0.528680223958638, 0.30792707633332, 0.805761473704592,
               0.827729745743828, 0.620664930419729, 0.579964117157681,
               0.729447578869235, 0.552141475908807, 0.35421736869287, 
               0.901705830498416, 0.159002000386583, 0.328330870595513))
expect_equal(resultM3[["ph1"]][["pValue"]],
             c(0.407435787913948, 0.805105670937091, 0.964246426324967, 
               0.605583783363822, 0.320687607161297, 0.878275623002467,
               0.735596707078479, 0.715282683139245, 0.652242698413956, 
               0.893256508621832, 0.489324007039571, 0.4572014821126, 
               0.986776018642498, 0.144328262539473, 0.239314470292116))

## Check effects.

expect_equal(stgM0[["GWAResult"]][["ph1"]][["effect"]],
             c(0.285463805823446, 0.275008877856299, -0.185599854928643, 
               -0.424617619883484, -0.712398380508194, -0.0754522284829272,
               -0.192398474941615, -0.415499530225841, 0.73532560606938,
               0.177125306434672, 0.304085745753239, 0.572151792527611,
               -0.2834638102598, -1.15453896169832, 1.32018117755578))
expect_equal(resultM1[["ph1"]][["effect"]],
             c(0.478657290637818, 0.156168493846892, 0.024681886858567,
               -0.48476259426359, -0.774125726474474, -0.0849221182857329,
               -0.339501955760045, -0.339555629834092, 0.644713270445932,
               0.138919783849337, 0.389551065611427, 0.547450363968916,
               -0.282282268900148, -1.30711113389411, 1.55024385917861))
expect_equal(resultM2[["ph1"]][["effect"]],
             c(0.265308804900334, 0.275008877856299, -0.128045494430347, 
               -0.369092200019993, -0.712398380508188, -0.240436936411258,
               -0.159432092876689, -0.415499530225846, 0.661364779536227,
               0.15338100490903, 0.304085745753242, 0.658001139967579, 
               -0.0863870055641748, -1.18613942560784, 1.08378380085274))
expect_equal(resultM3[["ph1"]][["effect"]],
             c(0.473158980432032, 0.156168493846891, 0.0418739727163797, 
               -0.357330050959815, -0.774125726474435, -0.169909238317249, 
               -0.29033803700914, -0.339555629834157, 0.611811817457268,
               0.0692213784590537, 0.389551065611514, 0.59345617871159, 
               -0.0130860982868268, -1.3071111338942, 1.41380947545818))

## Check values for traits containing NAs.

expect_equal(stgM1[["GWAResult"]][["ph2"]][["pValue"]],
             c(0.535844484978954, 0.73816131639574, NA, 0.862852200658273, 
               0.708010859433131, 0.814651977456774, 0.922966781776299, 
               0.697218755067958, 0.448256764397266, 0.572043172139475,
               0.491384394408418, 0.275542155776965, 0.970479338829502, 
               0.404773150600467, 0.282832797764826))
expect_equal(stgM1[["GWAResult"]][["ph2"]][["effect"]],
             c(0.384333657980093, 0.234905610232891, NA, 0.0993043428570975, 
               0.313577259848437, -0.197048130360462, -0.0732484057095593, 
               -0.338112413513171, 0.846392759230917, -0.254094633622612,
               -0.433221515932855, 0.684879321868275, -0.0229687434840074,
               -0.710010987816544, 0.919331574832678))
