% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnsleyKohn.R
\name{CoeffARMA}
\alias{CoeffARMA}
\title{Transform arbitrary matrices into ARMA coefficient matrices}
\usage{
CoeffARMA(A, variance = NULL, ar = 1, ma = 0)
}
\arguments{
\item{A}{An array of arbitrary square matrices in the multivariate case,
or a vector of arbitrary numbers in the univariate case.}

\item{variance}{A variance - covariance matrix.
Note: \code{variance} not needed for the univariate case!}

\item{ar}{The order of the AR part.}

\item{ma}{The order of the MA part.}
}
\value{
If multivariate, a list containing:
\itemize{
\item An array of coefficient matrices for the AR part.
\item An array of coefficient matrices for the MA part.
}

If univariate, a list containing:
\itemize{
\item A vector of coefficients for the AR part.
\item A vector of coefficients for the MA part.
}
}
\description{
Creates coefficient matrices for which the characteristic polynomial
corresponds to a stationary process.
See \insertCite{ansley1986note;textual}{statespacer} for details about
the transformation used.
}
\examples{
CoeffARMA(A = stats::rnorm(2), ar = 1, ma = 1)
}
\references{
\insertRef{ansley1986note}{statespacer}
}
\author{
Dylan Beijers, \email{dylanbeijers@gmail.com}
}
