% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BlockMatrix.R
\name{BlockMatrix}
\alias{BlockMatrix}
\title{Combine Matrices into a Block Diagonal Matrix}
\usage{
BlockMatrix(A = NULL, ...)
}
\arguments{
\item{A}{The first block matrix to be put on the diagonal.}

\item{...}{Other block matrices that should be put on the diagonal.}
}
\value{
Block diagonal matrix consisting of the specified matrices.
}
\description{
Creates a block diagonal matrix with its arguments as the blocks.
}
\details{
\code{BlockMatrix()} tries to coerce its arguments to a matrix,
using \code{\link[base:matrix]{as.matrix}}.
}
\examples{
BlockMatrix(diag(ceiling(50 * stats::runif(5))), matrix(1:8, 4, 2), c(14,8))

}
\author{
Dylan Beijers, \email{dylanbeijers@gmail.com}
}
