% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_up.R
\name{sum_up}
\alias{sum_up}
\alias{sum_up_}
\title{Gives summary statistics (corresponds to Stata command summarize)}
\usage{
sum_up(x, ..., d = FALSE, w = NULL, i = NULL)

sum_up_(x, ..., .dots, d = FALSE, w = NULL, i = NULL)
}
\arguments{
\item{x}{a data.frame}

\item{...}{Variables to include. Defaults to all non-grouping variables. See the \link[dplyr]{select} documentation.}

\item{d}{Should detailed summary statistics be printed?}

\item{w}{Weights. Default to NULL.}

\item{i}{Condition}

\item{.dots}{Used to work around non-standard evaluation.}
}
\value{
a data.frame
}
\description{
Gives summary statistics (corresponds to Stata command summarize)
}
\examples{
library(dplyr)
N <- 100
df <- data_frame(
  id = 1:N,
  v1 = sample(5, N, TRUE),
  v2 = sample(1e6, N, TRUE)
)
sum_up(df)
sum_up(df, v2, d = TRUE)
sum_up(df, v2, d = TRUE, i = v1>3)
df \%>\% group_by(v1) \%>\% sum_up(starts_with("v"))
}
