% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/count_combinations.R
\name{count_combinations}
\alias{count_combinations}
\title{Find best string combinations that identify an id}
\usage{
count_combinations(id, name, n = 1)
}
\arguments{
\item{id}{a vector of identifiers}

\item{name}{a vector of characters}

\item{n}{number of words for combinations. Default to \code{1}.}
}
\value{
\code{tab_accross} returns a data.frame of four columns. The first is id, the second corresponds to unique combination of words in each element of \code{v} with length lower than \code{n} (sorted alphabetically),  the third is the count of these permutation within \code{id}, the fourth is the count of these permutation accross \code{i}. Intuitively, when the count accross group is 1 and the count within group is high, the element can be considered as an identifier of the group.
}
\description{
Find best string combinations that identify an id
}
\examples{
library(stringdist)
id <- c(1, 1, 2, 2)
name <- c("coca cola company", "coca cola incorporated", "apple incorporated", "apple corp")
count_combinations(id, name)
count_combinations(id, name, n = 2)
}

