% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_exp.R
\name{ci_exp}
\alias{ci_exp}
\title{Confidence Interval of Exponential Distribution}
\usage{
ci_exp(x, conf_level = 0.95, type = "two.sided", na.rm = F)
}
\arguments{
\item{x}{a (non-empty) numeric vector.}

\item{conf_level}{confidence level of the returned confidence interval. Must be a single number between 0 and 1.}

\item{type}{a character string specifying the type of confidence interval. Must be one of "two.sided" (default), "right" or "less".}

\item{na.rm}{a logical value indicating whether ‘NA’ values should be stripped before the computation proceeds.}
}
\value{
A 1 x 3 tibble with 'lower_ci', 'upper_ci' and 'conf_level' columns. Values correspond to lower, upper bounds of the confidence interval and confidence level, respectively.
}
\description{
Confidence Interval of Exponential Distribution
}
\details{
"lower_ci" and "upper_ci" are computed using pivotal quantity, as explained by Montgomery and Runger <<ISBN: 978-1-119-74635-5>.
}
\examples{
x <- rexp(1000)
ci_exp(x)

}
