% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDR.discrete.R
\name{HDR.discrete}
\alias{HDR.discrete}
\title{Highest density region (HDR) for an arbitrary discrete distribution}
\usage{
HDR.discrete(
  cover.prob,
  f,
  supp.min = -Inf,
  supp.max = Inf,
  E = NULL,
  ...,
  distribution = "an unspecified input distribution"
)
}
\arguments{
\item{cover.prob}{The minimum coverage probability for the region}

\item{f}{The density (mass) function for the distribution}

\item{supp.min}{A minimum bound for the support of the distribution}

\item{supp.max}{A maximum bound for the support of the distribution}

\item{E}{A bijective function mapping the natural numbers (1,2,3,...) to a set covering the support of the distribution (optional);
if included, the algorithm will search the support of the distribution in the order specified by this function; if not included,
the algorithm will search the integers in a default order.}

\item{...}{additional parameters of f}

\item{distribution}{a label}
}
\value{
If all inputs are correctly specified (i.e., arguments and parameters are in allowable range)
then the output will be a list of class ```hdr``` containing the HDR and related information.
}
\description{
This function computes the highest density region (HDR) with support on the integers.  The distribution can be any discrete
distribution concentrated on the integers --- it does not have to have any shape properties for the function to work.  The user
must give the density function ```f``` for the distribution.  To improve the search properties of the algorithm, the user can
also give lower and upper bounds for the support of the distribution if these are available.  (Warning: If the user specifies
incorrect bounds on the support, that do not contain the full support of the distribution, then the algorithm may continue to
search without end, in which case the function will not terminate.  Similarly, if the user specifies a sequence function E that
is not a proper bijection to the integers then the algorithm may continue to search without end, in which case the function will
not terminate.) The output of the function is a \code{'hdr'} object containing the HDR for the discrete distribution.
}
