% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phase2_progress.R
\name{panel_progress}
\alias{panel_progress}
\title{Create the progress panel}
\usage{
panel_progress(df_app, nsteps, cluster_option,
                        func_progress_node = NULL,
                        func_progress_global = NULL,
                        cluster_func = "Mode Density",
                        show_abe = TRUE,
                        plot_node_lines = FALSE,
                        plot_cluster_info = FALSE,
                        abe_label_pos_y = 0.05,
                        abe_label_pos_x = 1.02)
}
\arguments{
\item{df_app}{starvz_data Application data}

\item{nsteps}{integer Number of times steps}

\item{cluster_option}{numeric In case of "Mode Density", the bandwidth}

\item{func_progress_node}{function progress funcion per node that return [0-1]}

\item{func_progress_global}{function progress function globaly that return [0-1]}

\item{cluster_func}{string "Mode Density" or "GMM"}

\item{show_abe}{boolean Add abe to plots}

\item{plot_node_lines}{boolean Add to return list the progress metric non-clustered}

\item{plot_cluster_info}{boolean Add to return list the plot of cluster information}

\item{abe_label_pos_y}{numeric ajust ABE label in y}

\item{abe_label_pos_x}{numeric ajust ABE label in x}
}
\value{
List, steps - numeric list of steps, step - numeric the number of steps,
original_metrics - ggplot, if plot_node_lines is true, plot_den - ggplot, if plot_cluster_info is true,
joined_data - tibble, cluster data computed, cluster_metrics - ggplot the progress cluster visualization
}
\description{
The progress panel show a progress metric per node, clustering nodes with
a similar metric
}
\examples{
panel_progress(starvz_sample_lu$Application, 20, 0.01, show_abe = FALSE)
}
