% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4-model-selection.R
\name{stages_bj}
\alias{stages_bj}
\title{Backward joining of stages}
\usage{
stages_bj(
  object = NULL,
  distance = "kullback",
  thr = 0.1,
  scope = NULL,
  ignore = object$name_unobserved,
  trace = 0
)
}
\arguments{
\item{object}{an object of class \code{sevt} with fitted probabilities and
data, as returned by \code{full} or \code{sevt_fit}.}

\item{distance}{character, see details.}

\item{thr}{the threshold for joining stages}

\item{scope}{names of variables that should be considered
for the optimization.}

\item{ignore}{vector of stages which will be ignored and left untouched,
by default the name of the unobserved stages stored in
\code{object$name_unobserved}.}

\item{trace}{if >0 increasingly amount of info
is printed (via \code{message}).}
}
\value{
The final staged event tree obtained.
}
\description{
Join stages from more complex to simpler models
using a distance and a threshold value.
}
\details{
For each variable in the model stages are joined iteratively.
At each iteration the two stages with minimum distance are selected and
joined if their distance is less than \code{thr}.

Available distances are: manhattan (\code{manhattan}), euclidean (\code{euclidean}),
Renyi divergence (\code{reny}), Kullback-Liebler (\code{kullback}),
total-variation (\code{totvar}), squared Hellinger (\code{hellinger}),
Bhattacharyya (\code{bhatt}), Chan-Darwiche (\code{chandarw}).
See also \link{probdist}.
}
\examples{
DD <- generate_xor_dataset(n = 5, N = 1000)
model <- stages_bj(full(DD, lambda = 1), trace = 2)
summary(model)
}
