% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4-model-selection.R
\name{join_zero_counts}
\alias{join_zero_counts}
\title{Join situations with no observations}
\usage{
join_zero_counts(object, fit = TRUE, trace = 0, name = NULL)
}
\arguments{
\item{object}{a fitted staged event tree}

\item{fit}{if the probability should be re-computed}

\item{trace}{if \code{> 0} print information to console}

\item{name}{string with a name for the new stage}
}
\value{
a staged event tree with situations with 0
observations merged in a single stage
}
\description{
Join situations with no observations
}
\details{
It takes as input a (fitted) staged event tree object
and looking at the \code{ctables} it joins, in the same stage, all the situations with zero
recorded observations. Since such joining does not change
the log-likelihood of the model, it is a useful (time-wise)
pre-processing before others model selection algorithms.
If \code{fit=TRUE} the model will be then re-fitted, if user sets
\code{fit=FALSE} the returned model will have no probabilities.
}
\examples{
DD <- generate_xor_dataset(n = 5, N = 1000)
model_full <- full(DD, lambda = 1)
model <- join_zero_counts(model_full, fit = TRUE)
logLik(model_full)
logLik(model)
BIC(model_full, model)
}
