% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_dc.R
\docType{class}
\name{report_dc-class}
\alias{report_dc-class}
\alias{report_dc}
\title{Class "report_dc" report du fonctionnement du dispositif de
comptage}
\description{
The counting device is not always working. It may me stopped either
following a monitoring protocol, or due to malfunction of the device, this
class allows to draw graphics allowing an overview of the device operation
}
\section{Slots}{

\describe{
\item{\code{data}}{A data frame}

\item{\code{dc}}{An object of class \code{ref_dc-class}}

\item{\code{horodatedebut}}{An object of class \code{ref_horodate-class}}

\item{\code{horodatefin}}{An object of class \code{ref_horodate-class}}
}}

\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("report_dc", ...)}.
}

\examples{

# this option allows to launch the program without the interface to display 
# some of the program features.
stacomi(database_expected=FALSE)
# An example that will work only if the database is present 
# and the program installed and comprises the schema iav
# prompt for user and password but you can set appropriate options for host, port and dbname
\dontrun{
	if (interactive()){
		if (!exists("user")){
			user <- readline(prompt="Enter user: ")
			password <- readline(prompt="Enter password: ")	
		}	
	}
	options(					
			stacomiR.dbname = "bd_contmig_nat",
			stacomiR.host ="localhost",
			stacomiR.port = "5432",
			stacomiR.user = user,
			stacomiR.user = password						
	)	
	
  r_dc=new("report_dc")
  r_dc<-choice_c(r_dc,
	  5,
	  horodatedebut="2000-01-01",
	  horodatefin="2015-12-31",
	  silent=TRUE)
  Sys.setenv(TZ='GMT')
  # This dataset format is GMT. If this option is not set
  # the dataset is tranformed from timestamp to date
  r_dc<-connect(r_dc)
  # this dataset has been loaded by the previous lines
  ###########################################################	
# Without connexion to the database (use dataset r_dc)
  ##########################################################
  data("r_dc")
  plot(r_dc,plot.type="1")
  plot(r_dc,plot.type="2")
  plot(r_dc,plot.type="3",main="trial title")
  plot(r_dc,plot.type="4",main="trial title")
# the following will write in the datawd folder
   summary(r_dc)
}
##




}
\seealso{
Other report Objects: 
\code{\link{report_annual-class}},
\code{\link{report_df-class}},
\code{\link{report_env-class}},
\code{\link{report_ge_weight-class}},
\code{\link{report_mig-class}},
\code{\link{report_mig_char-class}},
\code{\link{report_mig_env-class}},
\code{\link{report_mig_interannual-class}},
\code{\link{report_mig_mult-class}},
\code{\link{report_sample_char-class}},
\code{\link{report_sea_age-class}},
\code{\link{report_silver_eel-class}},
\code{\link{report_species-class}}
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}
\concept{report Objects}
\keyword{classes}
