% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_parquan.R
\docType{methods}
\name{charge_with_filter,ref_parquan-method}
\alias{charge_with_filter,ref_parquan-method}
\title{Loading method for Reparquan referential objects searching only those parameters existing for a DC, a Taxon, and a stage}
\usage{
\S4method{charge_with_filter}{ref_parquan}(object, dc_selectionne,
  taxa_selectionne, stage_selectionne)
}
\arguments{
\item{object}{An object of class \link{ref_parquan-class}}

\item{dc_selectionne}{The dc set in the report object}

\item{taxa_selectionne}{The taxa set in the report object}

\item{stage_selectionne}{The stage set in the report object}
}
\value{
An S4 object of class ref_parqualn
}
\description{
Loading method for Reparquan referential objects searching only those parameters existing for a DC, a Taxon, and a stage
}
\examples{
\dontrun{
 dc_selectionne=6
taxa_selectionne=2038
 stage_selectionne="AGJ"
 object=new("ref_parquan")
 charge_with_filter(object,dc_selectionne,taxa_selectionne,stage_selectionne)
}		
}
\author{
Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}

