% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approxAUC.R
\name{approxAUC}
\alias{approxAUC}
\title{Approximate AUC}
\usage{
approxAUC(y, yhat, n = 1000)
}
\arguments{
\item{y}{the actual class labels [0-1]}

\item{yhat}{the predicted probabilities}

\item{n}{number of samples to draw}
}
\description{
AUC can be computed exactly by sorting the fitted values, which is often
computationally slow. Instead, we can approximate the AUC numerically using
monte carlo.
}
\examples{
g <- glm(y~x,data=data.frame(x=1:10,y=1:10))
classMethods(g)

}
\references{
\url{http://stackoverflow.com/questions/4903092/calculate-auc-in-r}
}
\author{
\href{http://stackoverflow.com/users/227734/erik}{erik}, Neal Fultz
}
