% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac_plot_functions.R
\name{eempf_report}
\alias{eempf_report}
\title{Create a html report of a PARAFAC analysis}
\usage{
eempf_report(pfmodel, export, eem_list = NULL, absorbance = NULL,
  meta = NULL, metacolumns = NULL, splithalf = FALSE, shmodel = NULL,
  performance = FALSE, residuals = FALSE, spp = 5, ...)
}
\arguments{
\item{pfmodel}{PARAFAC model}

\item{export}{path to exported html file}

\item{eem_list}{optional EEM data}

\item{absorbance}{optional absorbance data}

\item{meta}{optional meta data table}

\item{metacolumns}{optional column names of metadata table}

\item{splithalf}{optional logical, states whether split-half analysis should be included}

\item{shmodel}{optional results from split-half analysis. If this data is not supplied but EEM data is available the split-half analysis is calculated on the creation of the report. Calculating the split-half analysis takes some time!}

\item{performance}{calculating model performance: \code{\link[staRdom]{eempf_eemqual}}}

\item{residuals}{logical, whether residuals are plotted in the report}

\item{spp}{plots per page for loadgins and residuals plot}

\item{...}{arguments to or from other functions}
}
\value{
TRUE if report was created
}
\description{
Create a html report of a PARAFAC analysis
}
\examples{
\donttest{
## no test yet
}
}
