% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosticPlot.R
\name{diagnostic_plot}
\alias{diagnostic_plot}
\title{Residual diagnostic plot for a STVAR model}
\usage{
diagnostic_plot(
  stvar,
  type = c("all", "series", "ac", "ch", "dist"),
  resid_type = c("standardized", "raw"),
  maxlag = 12
)
}
\arguments{
\item{stvar}{object of class \code{"stvar"}}

\item{type}{which type of diagnostic plot should be plotted?
\itemize{
  \item{\code{"all"} all below sequentially.}
  \item{\code{"series"} the residual time series.}
  \item{\code{"ac"} the residual autocorrelation and cross-correlation functions.}
  \item{\code{"ch"} the squared residual autocorrelation and cross-correlation functions.}
  \item{\code{"dist"} the residual histogram with theoretical density (dashed line) and QQ-plots.}
}}

\item{resid_type}{should standardized or raw residuals be used?}

\item{maxlag}{the maximum lag considered in types \code{"ac"} and \code{"ch"}.}
}
\value{
No return value, called for its side effect of plotting the diagnostic plot.
}
\description{
\code{diagnostic_plot} plots a multivariate residual diagnostic plot
  for either autocorrelation, conditional heteroskedasticity, or distribution,
  or simply draws the residual time series.
}
\details{
Auto- and cross-correlations (types \code{"ac"} and \code{"ch"}) are calculated with the function
 \code{acf} from the package \code{stats} and the plot method for class \code{'acf'} objects is employed.

 If \code{cond_dist == "Student"} or \code{"ind_Student"}, the estimates of the degrees of freedom parameters is used in
 theoretical densities and quantiles. If \code{cond_dist == "ind_skewed_t"}, the estimates of the degrees of freedom and
 skewness parameters are used in theoretical densities and quantiles, and the quantile function is computed numerically.
}
\examples{
## Gaussian STVAR p=1, M=2 model, with weighted relative stationary densities
# of the regimes as the transition weight function:
theta_122relg <- c(0.734054, 0.225598, 0.705744, 0.187897, 0.259626, -0.000863,
  -0.3124, 0.505251, 0.298483, 0.030096, -0.176925, 0.838898, 0.310863, 0.007512,
  0.018244, 0.949533, -0.016941, 0.121403, 0.573269)
mod122 <- STVAR(data=gdpdef, p=1, M=2, params=theta_122relg)

# Autocorelation function of raw residuals for checking remaining autocorrelation:
diagnostic_plot(mod122, type="ac", resid_type="raw")

# Autocorelation function of squared standardized residuals for checking remaining
# conditional heteroskedasticity:
diagnostic_plot(mod122, type="ch", resid_type="standardized")

# Below, ACF of squared raw residuals, which is not very informative for evaluating
# adequacy to capture conditional heteroskedasticity, since it doesn't take into account
# the time-varying conditional covariance matrix of the model:
diagnostic_plot(mod122, type="ch", resid_type="raw")

# Similarly, below the time series of raw residuals first, and then the
# time series of standardized residuals. The latter is more informative
# for evaluating adequacy:
diagnostic_plot(mod122, type="series", resid_type="raw")
diagnostic_plot(mod122, type="series", resid_type="standardized")

# Also similarly, histogram and Q-Q plots are more informative for standardized
# residuals when evaluating model adequacy:
diagnostic_plot(mod122, type="dist", resid_type="raw") # Bad fit for GDPDEF
diagnostic_plot(mod122, type="dist", resid_type="standardized") # Good fit for GDPDEF

## Linear Gaussian VAR p=1 model:
theta_112 <- c(0.649526, 0.066507, 0.288526, 0.021767, -0.144024, 0.897103,
  0.601786, -0.002945, 0.067224)
mod112 <- STVAR(data=gdpdef, p=1, M=1, params=theta_112)
diagnostic_plot(mod112, resid_type="standardized") # All plots for std. resids
diagnostic_plot(mod112, resid_type="raw") # All plots for raw residuals
}
\references{
\itemize{
   \item Anderson H., Vahid F. 1998. Testing multiple equation systems for common nonlinear components.
     \emph{Journal of Econometrics}, \strong{84}:1, 1-36.
   \item Hansen B.E. 1994. Autoregressive Conditional Density estimation.
     \emph{Journal of Econometrics}, \strong{35}:3, 705-730.
   \item Kheifets I.L., Saikkonen P.J. 2020. Stationarity and ergodicity of Vector STAR models.
     \emph{International Economic Review}, \strong{35}:3, 407-414.
   \item Lanne M., Virolainen S. 2025. A Gaussian smooth transition vector autoregressive model:
      An application to the macroeconomic effects of severe weather shocks. Unpublished working
      paper, available as arXiv:2403.14216.
   \item Lütkepohl H. 2005. New Introduction to Multiple Time Series Analysis,
         \emph{Springer}.
   \item McElroy T. 2017. Computation of vector ARMA autocovariances.
         \emph{Statistics and Probability Letters}, \strong{124}, 92-96.
   \item Kilian L., Lütkepohl H. 20017. Structural Vector Autoregressive Analysis. 1st edition.
     \emph{Cambridge University Press}, Cambridge.
   \item Tsay R. 1998. Testing and Modeling Multivariate Threshold Models.
     \emph{Journal of the American Statistical Association}, \strong{93}:443, 1188-1202.
   \item Virolainen S. 2025. Identification by non-Gaussianity in structural threshold and
      smooth transition vector autoregressive models. Unpublished working
      paper, available as arXiv:2404.19707.
 }
}
\seealso{
\code{\link{Portmanteau_test}}, \code{\link{profile_logliks}}, \code{\link{fitSTVAR}}, \code{\link{STVAR}},
 \code{\link{LR_test}}, \code{\link{Wald_test}}, \code{\link{Rao_test}}
}
