% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pickParams.R
\name{pick_lambdas}
\alias{pick_lambdas}
\title{Pick the structural parameter eigenvalues 'lambdas'}
\usage{
pick_lambdas(
  p,
  M,
  d,
  params,
  identification = c("reduced_form", "recursive", "heteroskedasticity",
    "non-Gaussianity")
)
}
\arguments{
\item{p}{a positive integer specifying the autoregressive order}

\item{M}{a positive integer specifying the number of regimes}

\item{params}{a real valued vector specifying the parameter values.
Should have the form \eqn{\theta = (\phi_{1},...,\phi_{M},\varphi_1,...,\varphi_M,\sigma,\alpha,\nu)},
where (see exceptions below):
\itemize{
  \item{\eqn{\phi_{m} = } the \eqn{(d \times 1)} intercept (or mean) vector of the \eqn{m}th regime.}
  \item{\eqn{\varphi_m = (vec(A_{m,1}),...,vec(A_{m,p}))} \eqn{(pd^2 \times 1)}.}
  \item{\describe{
    \item{if \code{cond_dist="Gaussian"} or \code{"Student"}:}{\eqn{\sigma = (vech(\Omega_1),...,vech(\Omega_M))}
      \eqn{(Md(d + 1)/2 \times 1)}.}
    \item{if \code{cond_dist="ind_Student"} or \code{"ind_skewed_t"}:}{\eqn{\sigma = (vec(B_1),...,vec(B_M)} \eqn{(Md^2 \times 1)}.}
    }
  }
  \item{\eqn{\alpha = } the \eqn{(a\times 1)} vector containing the transition weight parameters (see below).}
  \item{\describe{
    \item{if \code{cond_dist = "Gaussian")}:}{Omit \eqn{\nu} from the parameter vector.}
    \item{if \code{cond_dist="Student"}:}{\eqn{\nu > 2} is the single degrees of freedom parameter.}
    \item{if \code{cond_dist="ind_Student"}:}{\eqn{\nu = (\nu_1,...,\nu_d)} \eqn{(d \times 1)}, \eqn{\nu_i > 2}.}
    \item{if \code{cond_dist="ind_skewed_t"}:}{\eqn{\nu = (\nu_1,...,\nu_d,\lambda_1,...,\lambda_d)} \eqn{(2d \times 1)},
     \eqn{\nu_i > 2} and \eqn{\lambda_i \in (0, 1)}.}
    }
  }
}
For models with...
\describe{
  \item{\code{weight_function="relative_dens"}:}{\eqn{\alpha = (\alpha_1,...,\alpha_{M-1})}
        \eqn{(M - 1 \times 1)}, where \eqn{\alpha_m} \eqn{(1\times 1), m=1,...,M-1} are the transition weight parameters.}
 \item{\code{weight_function="logistic"}:}{\eqn{\alpha = (c,\gamma)}
        \eqn{(2 \times 1)}, where \eqn{c\in\mathbb{R}} is the location parameter and \eqn{\gamma >0} is the scale parameter.}
  \item{\code{weight_function="mlogit"}:}{\eqn{\alpha = (\gamma_1,...,\gamma_M)} \eqn{((M-1)k\times 1)},
        where \eqn{\gamma_m} \eqn{(k\times 1)}, \eqn{m=1,...,M-1} contains the multinomial logit-regression coefficients
        of the \eqn{m}th regime. Specifically, for switching variables with indices in \eqn{I\subset\lbrace 1,...,d\rbrace}, and with
       \eqn{\tilde{p}\in\lbrace 1,...,p\rbrace} lags included, \eqn{\gamma_m} contains the coefficients for the vector
       \eqn{z_{t-1} = (1,\tilde{z}_{\min\lbrace I\rbrace},...,\tilde{z}_{\max\lbrace I\rbrace})}, where
       \eqn{\tilde{z}_{i} =(y_{it-1},...,y_{it-\tilde{p}})}, \eqn{i\in I}. So \eqn{k=1+|I|\tilde{p}}
       where \eqn{|I|} denotes the number of elements in \eqn{I}.}
  \item{\code{weight_function="exponential"}:}{\eqn{\alpha = (c,\gamma)}
        \eqn{(2 \times 1)}, where \eqn{c\in\mathbb{R}} is the location parameter and \eqn{\gamma >0} is the scale parameter.}
  \item{\code{weight_function="threshold"}:}{\eqn{\alpha = (r_1,...,r_{M-1})}
        \eqn{(M-1 \times 1)}, where \eqn{r_1,...,r_{M-1}} are the thresholds.}
  \item{\code{weight_function="exogenous"}:}{Omit \eqn{\alpha} from the parameter vector.}
  \item{AR_constraints:}{Replace \eqn{\varphi_1,...,\varphi_M} with \eqn{\psi} as described in the argument \code{AR_constraints}.}
  \item{mean_constraints:}{Replace \eqn{\phi_{1},...,\phi_{M}} with \eqn{(\mu_{1},...,\mu_{g})} where
        \eqn{\mu_i, \ (d\times 1)} is the mean parameter for group \eqn{i} and \eqn{g} is the number of groups.}
  \item{weight_constraints:}{If linear constraints are imposed, replace \eqn{\alpha} with \eqn{\xi} as described in the
   argument \code{weigh_constraints}. If weight functions parameters are imposed to be fixed values, simply drop \eqn{\alpha}
   from the parameter vector.}
  \item{\code{identification="heteroskedasticity"}:}{\eqn{\sigma = (vec(W),\lambda_2,...,\lambda_M)}, where
        \eqn{W} \eqn{(d\times d)} and \eqn{\lambda_m} \eqn{(d\times 1)}, \eqn{m=2,...,M}, satisfy
        \eqn{\Omega_1=WW'} and \eqn{\Omega_m=W\Lambda_mW'}, \eqn{\Lambda_m=diag(\lambda_{m1},...,\lambda_{md})},
        \eqn{\lambda_{mi}>0}, \eqn{m=2,...,M}, \eqn{i=1,...,d}.}
  \item{B_constraints:}{For models identified by heteroskedasticity, replace \eqn{vec(W)} with \eqn{\tilde{vec}(W)}
        that stacks the columns of the matrix \eqn{W} in to vector so that the elements that are constrained to zero
        are not included. For models identified by non-Gaussianity, replace \eqn{vec(B_1),...,vec(B_M)} with
        similarly with vectorized versions \eqn{B_m} so that the elements that are constrained to zero are not included.}
}
Above, \eqn{\phi_{m}} is the intercept parameter, \eqn{A_{m,i}} denotes the \eqn{i}th coefficient matrix of the \eqn{m}th
regime, \eqn{\Omega_{m}} denotes the positive definite error term covariance matrix of the \eqn{m}th regime, and \eqn{B_m}
is the invertible \eqn{(d\times d)} impact matrix of the \eqn{m}th regime. \eqn{\nu_m} is the degrees of freedom parameter
of the \eqn{m}th regime.
If \code{parametrization=="mean"}, just replace each \eqn{\phi_{m}} with regimewise mean \eqn{\mu_{m}}.
\eqn{vec()} is vectorization operator that stacks columns of a given matrix into a vector. \eqn{vech()} stacks columns
of a given matrix from the principal diagonal downwards (including elements on the diagonal) into a vector. \eqn{Bvec()}
is a vectorization operator that stacks the columns of a given impact matrix \eqn{B_m} into a vector so that the elements
that are constrained to zero by the argument \code{B_constraints} are excluded.}

\item{identification}{is it reduced form model or an identified structural model; if the latter, how is it identified
(see the vignette or the references for details)?
\describe{
  \item{\code{"reduced_form"}:}{Reduced form model.}
  \item{\code{"recursive"}:}{The usual lower-triangular recursive identification of the shocks via their impact responses.}
  \item{\code{"heteroskedasticity"}:}{Identification by conditional heteroskedasticity, which imposes constant relative
    impact responses for each shock.}
  \item{\code{"non-Gaussianity"}:}{Identification by non-Gaussianity; requires mutually independent non-Gaussian shocks, thus,
    currently available only with the conditional distribution \code{"ind_Student"}.}
}}
}
\value{
Returns the length \code{(d*(M - 1))} vector \eqn{(\lambda_{2},...,\lambda_{M})}
 (see the argument \code{params}) for structural models identified by heteroskedasticity,
 \code{numeric(0)} if \eqn{M=1}, and \code{NULL} for other models.
}
\description{
\code{pick_lambdas} picks the structural parameters eigenvalue 'lambdas' from the parameter vector
  of a structural model identified by heteroskedasticity.
}
\details{
Constrained parameter vectors are not supported. Not even constraints in \eqn{W}!
}
\references{
\itemize{
   \item Lütkepohl H., Netšunajev A. 2017. Structural vector autoregressions with smooth transition in variances.
     \emph{Journal of Economic Dynamics & Control}, \strong{84}, 43-57.
 }
}
\keyword{internal}
