% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/health-valuation.R
\name{valInfo.health}
\alias{valInfo.health}
\title{Providing Information for Health Item Valuation from a marketRisk and a healthRisk}
\usage{
\method{valInfo}{health}(object, market.risk, health.risk, total.vola = T,
  ...)
}
\arguments{
\item{object}{S3 object of class health.}

\item{market.risk}{S3 object of class marketRisk created using the constructor
\code{marketRisk}.}

\item{health.risk}{S3 object of class healthRisk created using the constructor
\code{healthRisk}.}

\item{total.vola}{a logical value, by default set to \code{TRUE}. Should we return the total
volatility? (otherwise the sensitivities).}

\item{...}{additional arguments.}
}
\value{
a numeric value: the agggregated volatility if
  \code{total.vola = TRUE}. Otherwise the named vector of volatilities
  for each health insurance risk factor.
}
\description{
\code{valInfo} is a generic S3 method for classes
  inheriting from item. It returns sufficient information for the
  creation of the valuation function of the item.
}
