% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketRisk-simulation.R
\name{compute.marketRisk}
\alias{compute.marketRisk}
\title{Compute a MarketRisk}
\usage{
\method{compute}{marketRisk}(object, market.items, standalones = NULL, nsim,
  seed = NULL, nested.market.computations = F, ...)
}
\arguments{
\item{object}{S3 object of class marketRisk.}

\item{market.items}{list with elements being object of S3 classes
inheriting from \code{marketRisk}.}

\item{standalones}{list of possible standalones (default NULL).}

\item{nsim}{strictly positive integer value of length one. The number
of simulations.}

\item{seed}{positive integer value of length one. The seed for
reproducibility.}

\item{nested.market.computations}{logical value of length one, by default set
to \code{FALSE}. Should the market items valuations be nested by item
types?}

\item{...}{additional arguments.}
}
\value{
a list of numeric values. The simulation results for a marketRisk.
}
\description{
\code{compute} is a generic S3 method for classes inheriting from risk.
It returns a vector of aggregated simulations for the corresponding risk.
}
\seealso{
\code{\link{compute}}, \code{\link{marketRisk}}.
}
