% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sspse-package.R
\docType{package}
\name{sspse-package}
\alias{sspse-package}
\title{Estimating Hidden Population Size using Respondent Driven Sampling Data}
\description{
An integrated set of tools to estimate the size of a networked population
based on respondent-driven sampling data. The "sspse" packages is part of
the "RDS Analyst" suite of packages for the analysis of respondent-driven
sampling data.  For a list of functions type:
help(package='sspse')
}
\details{
For a complete list of the functions, use \code{library(help="sspse")} or
read the rest of the manual.

When publishing results obtained using this package the original authors are
to be cited as:

Gile, Krista J. and Handcock, Mark S. (2018) \pkg{sspse}: Estimating Hidden 
Population Size using Respondent Driven Sampling Data
R package, Los Angeles, CA.  Version 0.8, \url{https://github.com/HPMRG}.

All programs derived from this package must cite it. For complete citation
information, use\cr \code{citation(package="sspse")}.

The package can also be accessed via graphical user interface
provided by the \code{RDS Analyst} software. 
\code{RDS Analyst} software was designed to help researchers
visualize and analyze data collected via respondent-driven sampling designs.
It has a broad range of estimation and visualization capabilities.

For detailed information on how to download and install the software, go to
the Hard-to-Reach Population Methods Research Group website: \url{https://github.com/HPMRG}.
A tutorial, support
newsgroup, references and links to further resources are provided there.
}
\references{
Gile, Krista J. (2008) \emph{Inference from Partially-Observed Network
Data}, Ph.D. Thesis, Department of Statistics, University of Washington.

Gile, Krista J. and Handcock, Mark S. (2010) \emph{Respondent-Driven
Sampling: An Assessment of Current Methodology}, Sociological Methodology
40, 285-327.

Gile, Krista J. and Handcock, Mark S. (2018) \pkg{sspse}: Estimating Hidden 
Population Size using Respondent Driven Sampling Data
R package, Los Angeles, CA.  Version 0.8, \url{https://github.com/HPMRG}.

Handcock MS (2003).  \pkg{degreenet}: Models for Skewed Count Distributions
Relevant to Networks.  Statnet Project, Seattle, WA.  Version 1.2,
\url{https://statnet.org}.

Handcock, Mark S., Gile, Krista J. and Mar, Corinne M. (2014)
\emph{Estimating Hidden Population Size using Respondent-Driven Sampling
Data}, Electronic Journal of Statistics, 8, 1, 1491-1521

Handcock, Mark S., Gile, Krista J. and Mar, Corinne M. (2015)
\emph{Estimating the Size of Populations at High Risk for HIV using Respondent-Driven 
Sampling Data}, Biometrics.
}
\author{
Krista J. Gile \email{gile@math.umass.edu},\cr
Mark S. Handcock \email{handcock@stat.ucla.edu}

Maintainer: Mark S. Handcock \email{handcock@stat.ucla.edu}
}
\keyword{models}
\keyword{package}
