% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm_aggregate_catch.R
\name{spm_aggregate_catch}
\alias{spm_aggregate_catch}
\alias{spm_aggregate_catch,sspm_dataset,sspm_dataset,character,character-method}
\title{Update biomass value from catch adta}
\usage{
spm_aggregate_catch(
  biomass,
  catch,
  biomass_variable,
  catch_variable,
  corrections = NULL,
  fun = sum,
  group_by = "spacetime",
  fill,
  apply_to_df = FALSE,
  ...
)

\S4method{spm_aggregate_catch}{sspm_dataset,sspm_dataset,character,character}(
  biomass,
  catch,
  biomass_variable,
  catch_variable,
  corrections = NULL,
  fun = sum,
  group_by = "spacetime",
  fill,
  apply_to_df = FALSE,
  ...
)
}
\arguments{
\item{biomass}{\strong{[sspm_dataset (smoothed)]} The dataset containing the
biomass variable.}

\item{catch}{\strong{[sspm_dataset]} The dataset containing the catch variable.}

\item{biomass_variable}{\strong{[character]} The biomass variab of \code{biomass}.}

\item{catch_variable}{\strong{[character]} The catch column of \code{catch}.}

\item{corrections}{\strong{[data.frame]} Optional landings corrections.}

\item{fun}{\strong{[function]} Function to use to aggregate data.}

\item{group_by}{\strong{[character]} One of \code{time}, \code{space} and \code{spacetime}.}

\item{fill}{\strong{[logical OR numeric OR function]} Whether to complete the
incomplete cases, default to \code{FALSE} for no completion.}

\item{apply_to_df}{\strong{[logical]} Wether \code{fun} applied to  the data frame
group or to \code{variable}, default to \code{FALSE}.}

\item{...}{More arguments passed onto \code{fun}}
}
\value{
Updated \code{sspm_dataset}.
}
\description{
Aggregate the catch data contained in a catch dataset and update the biomass
dataset with the subtracted catch.
}
\examples{
\dontrun{
spm_aggregate_catch(biomass = biomass_smooth, catch = catch_dataset,
                    biomass_variable = "weight_per_km2",
                    catch_variable = "catch",
                    fill = mean)
}

}
