% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCinitial.R
\name{HCinitial}
\alias{HCinitial}
\title{Two-Step Method for Parameter Estimation of the Heckman Model}
\usage{
HCinitial(selection, outcome, data = sys.frame(sys.parent()))
}
\arguments{
\item{selection}{Selection equation.}

\item{outcome}{Primary Regression Equation.}

\item{data}{Database.}
}
\value{
Returns a numerical vector with estimates
of the parameters of the classical Heckman
model using the two-step method
}
\description{
Estimates the parameters of the classic
Heckman model via the two-step method.
}
\details{
Generally, the two-step method is very
useful for finding initial values for
the Likelihood Estimation method. In
first step performs a probit analysis
on a selection equation. The second
step analyzes an outcome equation based
on the first-step binary probit model.
}
\examples{
data(MEPS2001)
attach(MEPS2001)
selectEq <- dambexp ~ age + female + educ + blhisp + totchr + ins + income
outcomeEq <- lnambx ~ age + female + educ + blhisp + totchr + ins
HCinitial(selectEq,outcomeEq, data = MEPS2001)

}
