% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.fitburrlioz}
\alias{predict.fitburrlioz}
\title{Predict Hazard Concentrations of fitburrlioz Object}
\usage{
\method{predict}{fitburrlioz}(
  object,
  percent,
  proportion = 1:99/100,
  ci = FALSE,
  level = 0.95,
  nboot = 1000,
  min_pboot = 0.95,
  parametric = TRUE,
  ...
)
}
\arguments{
\item{object}{The object.}

\item{percent}{A numeric vector of percent values to estimate hazard concentrations for. Deprecated for \code{proportion = 0.05}. \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{proportion}{A numeric vector of proportion values to estimate hazard concentrations for.}

\item{ci}{A flag specifying whether to estimate confidence intervals (by bootstrapping).}

\item{level}{A number between 0 and 1 of the confidence level of the interval.}

\item{nboot}{A count of the number of bootstrap samples to use to estimate the confidence limits. A value of 10,000 is recommended for official guidelines.}

\item{min_pboot}{A number between 0 and 1 of the minimum
proportion of bootstrap samples that must successfully fit (return a likelihood)
to report the confidence intervals.}

\item{parametric}{A flag specifying whether to perform parametric bootstrapping as opposed to non-parametrically resampling the original data with replacement.}

\item{...}{Unused.}
}
\description{
A wrapper on \code{\link[=ssd_hc]{ssd_hc()}} that by default calculates
all hazard concentrations from 1 to 99\%.
}
\details{
It is useful for plotting purposes.
}
\examples{
fits <- ssd_fit_burrlioz(ssddata::ccme_boron)
predict(fits)
}
\seealso{
\code{\link[=ssd_hc]{ssd_hc()}} and \code{\link[=ssd_plot]{ssd_plot()}}
}
