% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgumbel.R
\name{lgumbel}
\alias{lgumbel}
\alias{dlgumbel}
\alias{plgumbel}
\alias{qlgumbel}
\alias{rlgumbel}
\alias{slgumbel}
\title{Log-Gumbel Distribution}
\usage{
dlgumbel(x, locationlog = 0, scalelog = 1, log = FALSE)

plgumbel(q, locationlog = 0, scalelog = 1, lower.tail = TRUE, log.p = FALSE)

qlgumbel(p, locationlog = 0, scalelog = 1, lower.tail = TRUE, log.p = FALSE)

rlgumbel(n, locationlog = 0, scalelog = 1)

slgumbel(x)
}
\arguments{
\item{x}{A numeric vector of values.}

\item{locationlog}{location on log scale parameter.}

\item{scalelog}{scale on log scale parameter.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \code{P[X <= x]},otherwise, \code{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
A numeric vector.
}
\description{
Probability density, cumulative distribution,
inverse cumulative distribution, random sample and starting values functions.
}
\examples{
x <- seq(0.01, 5, by = 0.01)
plot(x, dlgumbel(x), type = "l")
}
