% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gompertz.R
\name{gompertz}
\alias{gompertz}
\alias{dgompertz}
\alias{qgompertz}
\alias{pgompertz}
\alias{rgompertz}
\alias{sgompertz}
\title{Gompertz Distribution}
\usage{
dgompertz(x, lscale = 0, lshape = 0, log = FALSE)

qgompertz(p, lscale = 0, lshape = 0, lower.tail = TRUE, log.p = FALSE)

pgompertz(q, lscale = 0, lshape = 0, lower.tail = TRUE, log.p = FALSE)

rgompertz(n, lscale = 0, lshape = 0)

sgompertz(x)
}
\arguments{
\item{x}{A numeric vector of values.}

\item{lscale}{scale parameter on the log scale.}

\item{lshape}{shape parameter on the log scale.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{vector of probabilities.}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x],otherwise, P[X > x].}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{n}{number of observations.}
}
\value{
A numeric vector.
}
\description{
Density, distribution function, quantile function, random generation
and starting values for the
Gompertz distribution.
}
\details{
The functions are wrappers on the equivalent VGAM functions that
return a zero length numeric vector if x, q or p are zero length.
}
\examples{
x <- seq(0.01, 5, by = 0.01)
plot(x, dgompertz(x), type = "l")
}
\seealso{
\code{\link[VGAM]{dgompertz}}
}
