% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helper.R
\name{check_genes_missing_total}
\alias{check_genes_missing_total}
\title{Function to Check if 100\% of Genes in Gene Sets Have Missing Information in Data Matrix}
\usage{
check_genes_missing_total(Gene_sets, Data)
}
\arguments{
\item{Gene_sets}{A list of gene sets to be analyzed, with gene set names as component names, and each component is a vector
of gene entrez ID.}

\item{Data}{Data matrix of gene expressions with gene ensembl ID as row names and columns corresponding to different samples.}
}
\value{
A list 'Total_missing_in_data_matrix' with names of the gene sets that have 100\% of genes that have information missing in the data matrix will be
returned. If there are no such gene sets, NULL list will be returned.
}
\description{
This function is to check if 100\% of genes in gene sets to be analyzed have missing information in data matrix.
}
\details{
Before single sample directional gene set analysis, it is necessary to check if genes in the gene sets have missing information in
data matrix. If a gene set has 100\% information missing in the data matrix, the name of the gene set will be returned as a list named
'Total_missing_in_data_matrix'; If no such gene sets exist, nothing will be returned.
}
