% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg_unload.R
\name{pkg_unload}
\alias{pkg_unload}
\title{unloads a package, unloading its dependent packages if needed}
\usage{
pkg_unload(
  pkg_or_name,
  src_pkgs = get_srcpkgs(),
  dry_run = FALSE,
  loaded = loadedNamespaces(),
  quiet = FALSE
)
}
\arguments{
\item{pkg_or_name}{a package name or object ("package" or "srcpkg")}

\item{src_pkgs}{a collection of source packages as a \code{srckgs} object.}

\item{dry_run}{whether not to actually execute any action having side-effects}

\item{loaded}{the loaded packages, useful for testing.}

\item{quiet}{whether to be quiet/silent}
}
\value{
a data frame of the unloaded package names, and whether they were
attached, invisibly or NULL if the package is not loaded
}
\description{
To be able to unload properly a package, all the packages that depend
even indirectly on it should be unloaded first.
}
\details{
N.B: this function also works for non source packages.
}
\examples{
\donttest{
plan <- pkg_unload('mypkg')
}
}
