\docType{package}
\name{squid}
\alias{squid}
\alias{squid-package}
\title{SQUID - Statistical Quantification of Individual Differences: an educational and statistical tool for understanding multi-level phenotypic data in linear mixed models}
\description{
SQuID stands for \strong{S}tatistical \strong{Qu}antification of \strong{I}ndividual \strong{D}ifferences and is the product of the SQuID working group. The package aims to help scholars who, like us, are interested in understanding patterns of phenotypic variance. Individual differences are the raw material for natural selection to act on and hence the basis of evolutionary adaptation. Understanding the sources of phenotypic variance is thus a most essential feature of biological investigation and mixed effects models offer a great, albeit challenging tool. Disseminating the properties, potentials and interpretational challenges in the research community is thus a foremost goal of SQuID.

The SQuID package has two main objectives: First, it provides an educational tool useful for students, teachers and researchers who want to learn to use mixed-effects models. Users can experience how the mixed-effects model framework can be used to understand distinct biological phenomena by interactively exploring simulated multilevel data. Second, SQuID offers research opportunities to those who are already familiar with mixed-effects models, as SQuID enables the generation of datasets that users may download and use for a range of simulation-based statistical analyses such as power and sensitivity analysis of multilevel and multivariate data.
}
\section{Background}{
The phenotype of a trait in an individual results from a sum of genetic and environmental influences. Phenotypic variation is structured in a hierarchical way and the hierarchical modeling in mixed effect models is great tool to analyze and decompose such variation. Phenotypes vary across species, across populations of the same species, across individuals of the same population, and across repeated observations of the same individual. We focused on the individual level because it represents one of the most important biological levels to both ecological and evolutionary processes. Different sources of variation are at the origin of the phenotype of an individual. Individuals may differ in their phenotypes because they carry different gene variants (i.e. alleles). But individuals also experience different environments during their lifetime. Some environmental influences impose a lasting mark on the phenotype, while others are more ephemerous. The former tend to produce long-lasting, among-individual variation, while the latter causes within-individual variation. However, this depends on the time scale at which the measurements of the phenotypes are done relative that of the environmental influences. Furthermore, individuals differ not only in their average phenotypes but also in how they respond to changes in their environment (i.e. differences in individual phenotypic plasticity). This represents an interaction between the among- and the within-individual levels of variation. The patterns of variation can, thus, be very complex. Selection can act differently on these different components of variance in the phenotypes of a trait, and this is why it is important to quantify their magnitude.

Mixed models are very flexible statistical tools that provide a way to estimate the variation at these different levels, and represent the general statistical framework for evolutionary biology. Because of the progress in computational capacities mixed models have become increasingly popular among ecologists and evolutionary biologists over the last decade. However, fitting mixed model is not a straightforward exercise, and the way data are sampled among and within individuals can have strong implications on the outcome of the model. This is why we created the SQuID simulation tool that could help new users interested in decomposing phenotypic variance to get more familiar with the concept of hierarchical organization of traits, with mixed models and to avoid pitfalls caused by inappropriate sampling. 
}
\section{Details}{
SQuID is a simulation-based tool that can be used for research and educational purposes. SQuID creates a world inhabited by individuals whose phenotypes are generated by a user-defined phenotypic equation, which allows easy translation of biological hypotheses into mathematically quantifiable parameters. The framework is suitable for performing simulation studies, determining optimal sampling designs for user-specific biological problems, and making simulation based inferences to aid in the interpretation of empirical studies. SQuID is also a teaching tool for biologists interested in learning, or teaching others, how to implement and interpret mixed-effects models, when studying the processes causing phenotypic variation. SQuID is based on a mathematical model that creates a group of individuals (i.e. study population) repeatedly expressing phenotypes, for one or two different traits, in uniform time. Phenotypic values of traits are generated following the general principle of the phenotypic equation (\href{http://onlinelibrary.wiley.com/doi/10.1111/1365-2656.12013/abstract}{Dingemanse & Dochtermann 2013, Journal of Animal Ecology}): phenotypes are assumed to be the summed effects of a series of components and the phenotypic variance (Vp) is the sum of the respective variances in theses causal components. The user has thus the flexibility to add different variance components that will form the phenotype of the individual at each time step, and to set up the relative importance of each component through the definition of environmental effects. SQuID then allows the user to collect a subsample of phenotypes for each simulated individual (i.e. operational data set), according to a specific sampling design. The major difference between SQuID and other R packages that also allow performance analysis through data simulation (e.g. \href{https://cran.r-project.org/package=pamm}{pamm}, \href{https://cran.r-project.org/package=odprism}{odprism}, \href{https://cran.r-project.org/package=simr}{simr}), is that only SQUID allows separate steps for generating the world first and then model a sampling process from it. SQuID is subject to evolution and is designed to adapt to more complex scenarios in the future.

SQuID has two main functions; \code{\link{squidApp}} and \code{\link{squidR}}.

\subsection{squidApp}{
This function runs the SQuID application which is a browser-based interface created with the \href{http://shiny.rstudio.com/}{shiny} package. SQuID is built up as a series of modules that guide the user into situations of increasing complexity to explore the phenotypic equation model and the dynamics between the way phenotypes are sampled and the estimation of parameters of specific interest; The last module is the full model simulation that allows the user to generate data sets that can then be used to run analyses in the statistical package of their choice for specific research questions. For most of the modules, the simulated data set is automatically fed into a statistical model in R and the main results of the analysis shown in an output. For the full model the user has the opportunity to download the operational data set for further analyses. The SQuID application also has a tab (Full model (Step by step)) describing in details the SQuID full model.
}
\subsection{squidR}{
This function is a traditional R function that allows data generation and sampling without the browser-based interface. This function can be used for more advanced and efficient simulations once you understand how SQuID works. squidR can be easily included in R scripts.
}
}
\section{References}{
Allegue, H., Araya-Ajoy, Y.G., Dingemanse, N.J., Dochtermann N.A., Garamszegi, L.Z., Nakagawa, S., Reale, D., Schielzeth, H. and Westneat, D.F. (2016) SQuID - Statistical Quantification of Individual Differences: an educational and statistical tool for understanding multi-level phenotypic data in linear mixed models. \emph{Methods in Ecology and Evolution}, \bold{8}:257-267.

Dingemanse, N.J. and Dochtermann N.A. (2013) Quantifying individual variation in behaviour: mixed-effect modelling approaches. \emph{Journal of Animal Ecology}, \bold{82}:39-54.
}