\name{makecmap}
\alias{makecmap}
\title{ 
Generate a color map from numeric values to colors
 }
\description{
  Generate a color map from numeric values to a contiguous set of colors.
}
\usage{
makecmap(x, n = 10, breaks = pretty, 
  symm = FALSE, base = NA, 
  colFn = jet, col.na = NA, 
  right = FALSE, include.lowest = FALSE, ...)
}
\arguments{
  \item{x}{ A vector of numbers (only the finite range is used). }
  \item{n}{ Approximate number of color levels desired. }
  \item{breaks}{ A function to generate breakpoints, or the breakpoints themselves. }
  \item{symm}{ Extend the mapping domain to be symmetric around zero? }
  \item{base}{ Base for log scale, or NA to use a linear scale. }
  \item{colFn}{ A function that generates contiguous colors. }
  \item{col.na}{ Color to use for missing values. }
  \item{right}{ Logical; if TRUE, the intervals will be closed on the right (and open on the left). }
  \item{include.lowest}{ Logical, indicating if an \code{x[i]} equal to the lowest (or highest, for right = FALSE) \code{breaks} value should be included. }
  \item{\dots}{ Further arguments to \code{breaks}. }
}
\details{
  The general point of this function is to automatically generate a mapping that can be used in combination with \code{\link{cmap}} to represent numeric data with colors in a consistent way.
  
  \code{colFn} should be a function that returns a vector of colors of specified length, such as \code{\link{rainbow}}, \code{\link{greyscale}}.  Custom functions of this type can be generated with \code{\link{colorRampPalette}}.
  
  The breakpoints can be specified explicitly by setting \code{breaks} to a vector of numbers, in which case \code{x} is ignored. Otherwise, the breakpoints are chosen to be nice, relatively round values (using \code{\link{pretty}}, or another function passed to \code{breaks}) covering the finite range of \code{x}.  
  
  If \code{symm} is TRUE, the map domain is extended such that it is symmetric around zero. This can be useful when using divergent color palettes to ensure that the zero point is a neutral color.

  If \code{base} is specified, the breakpoints are generated using log-transformed data. However, setting \code{breaks = prettyLog} might be preferable.
}
\value{
A list with the following components:
  \item{breaks }{ Breakpoints (numeric vector).}
  \item{colors }{ Colors (character or numeric vector). }
  \item{base }{ (as supplied in arguments) }
  \item{col.na }{ (as supplied in arguments) }
  \item{right  }{ (as supplied in arguments) }
  \item{include.lowest }{ (as supplied in arguments) }
}
\seealso{ 
  \code{\link{cmap}} and \code{\link{colorgram}} use the mappings generated by this function. 
  
  \code{\link{hkey}} plots a color key.
  
  Consider setting \code{breaks = \link{prettyInt}} or \code{breaks = \link{prettyLog}}
}
\examples{
  attach(iris)
  map1 <- makecmap(Petal.Length)
  myColors <- cmap(Petal.Length, map = map1)
  plot(Sepal.Length, Sepal.Width, col = myColors, pch = 16)
  hkey(map1, title = 'Petal.Length')

  ## Compare the 'breaks' element in the following:
  x <- rnorm(100) * 1000
  str(makecmap(x))
  str(makecmap(x, breaks = c(-Inf, -1000, 0, 1000, Inf)))
  str(makecmap(x, breaks = prettyLog))


}
\keyword{ color }
