% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transBoundFun.R
\name{transBoundFun}
\alias{transBoundFun}
\title{Creates Parameter Transformation and Backtransformation Rules for the Estimation Procedure}
\usage{
transBoundFun(parL, shpmodel, weightmethod)
}
\arguments{
\item{parL}{a list with 4 numeric vectors specifying:
\tabular{lll}{
    \code{p}\tab{Vector of model parameters, has to coincide with the chosen soil hydraulic property model. If \code{weightmethod == est1} then two additional nuisance parameters, need to be specified and concatenated to the vector of soil hydraulic property model parameters, a first, for THETA and a second for log10K)}\cr
    \code{psel}\tab{vector identifying which parameters are to be estimatedmodel parameters, has to coincide with the chosen soil hydraulic property model}\cr
    \code{plo}\tab{vector of lower bounds (non-transformed parameter boundaries)}\cr
    \code{pup}\tab{vector of upper bounds (non-transformed parameters boundaries)}\cr
}}

\item{shpmodel}{A string specifying the selected soil hydraulic property model.}

\item{weightmethod}{A string specifying the selected weigthing method, if weightmethod == "est1" is TRUE, then \code{parL} is modified to account for nuisance parameters).}
}
\value{
a list of two lists. One of the sub-lists is \code{parL} but with transformed parameters, and the second, \code{transL} with model specific transformation and back-transformation rules.
}
\description{
Creates Parameter Transformation and Backtransformation Rules for the Estimation Procedure
}
\details{
This function is intended for the function \code{shypEstFun} so that lists with set rules for the transformation and back-transformation of the soil hydraulic model
parameters are enabled. In general, the following rules apply \code{log10} transformation for the model parameters \eqn{\alpha_i}, \code{n_i-1}, \code{K_s}, \code{K_sc}, \code{K_snc}.

The function is meant for internal use in \code{shypEstFun}.
}
\examples{

parL <- list("p" = c("thr"= 0.05, "ths" = 0.45, "alf1" = 0.01, "n" = 2, "Ks" = 100, "tau" = .5),
            "psel" = c(1, 1, 0, 1, 1, 1),
            "plo" = c(0.001 , 0.2, 0.001, 1.1, 1, -2),
            "pup" = c(0.3, 0.95, 1, 10, 1e4, 10))

# transformation and back-transformation of parameter vectors
for(k in c("p", "plo", "pup")){
     for (j in c("none")){
           parL.trans <- transBoundFun(parL, shpmodel = "01110", weightmethod = j)
           
           p_trans <- transFun(parL[[k]], parL.trans$transL$ptrans)
           p_retrans <- transFun(p_trans, parL.trans$transL$pretrans)
           
           stopifnot(sum(p_retrans != parL[[k]])==0)
     }
}


}
\author{
Tobias KD Weber , \email{tobias.weber@uni-hohenheim.de}
}
