% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputs.R
\name{textButton}
\alias{textButton}
\title{Text input with an action button}
\usage{
textButton(
  textId,
  btnId = paste0(textId, "_btn"),
  label = "",
  text_value = "",
  placeholder = "",
  tooltip = "",
  placement = "bottom",
  btn_icon = NULL,
  btn_label = "btn",
  style = "",
  ...
)
}
\arguments{
\item{textId}{the text input ID}

\item{btnId}{the button ID, if not specified, it is "textId" + "_btn" like, \code{textId_btn}}

\item{label}{label of the whole group, on the top}

\item{text_value}{initial value of the text input}

\item{placeholder}{placeholder text of the text input}

\item{tooltip}{a tooltip of the group}

\item{placement}{where should the tooltip go?}

\item{btn_icon}{a \link[shiny:icon]{shiny::icon} of the button}

\item{btn_label}{text on the button}

\item{style}{additional CSS style of the group}

\item{...}{additional args pass to the button, see \link[shiny:actionButton]{shiny::actionButton}}
}
\value{
a shiny input group
}
\description{
One kind of bootstrap3 input group: a textinput and a button attached
to the end
}
\examples{
if(interactive()){
  library(shiny)

  ui <- fluidPage(
    column(
      6,
      textButton(textId = "tbtn_default", label = "default"),
      textButton(
        textId = "tbtn-icon",
        label = "change icon and color",
        btn_icon = icon("home"),
        class = "btn-warning" # pass to the button
      ),
      textButton(
        textId = "tbtn_style",
        label = "change styles",
        style = "color: red; border: 2px dashed green;"
      ),
      textButton(
        textId = "tbtn_submit",
        label = "interact with shiny server",
        btn_label = "Submit",
        placeholder = "type and submit",
        class = "btn-primary"),
      verbatimTextOutput("tbtn_submit_out")
    )
  )

  server <- function(input, output, session) {
    # watch for the button ID "tbtn_submit" + "_btn"
    observeEvent(input$tbtn_submit_btn, {
      output$tbtn_submit_out <- renderPrint(isolate(input$tbtn_submit))
    })

  }

  shinyApp(ui, server)
}
}
