% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Newark.sf}
\alias{Newark.sf}
\title{Extract of 1880 US Census for Newark, New Jersey.}
\format{
A simple features dataframe with 21,520 rows and 8 columns:
\describe{
  \item{ID}{Unique identifier of record.}
  \item{YANKEE}{Dummy variable for ethnicity of respondent: 1 if Yankee, 0 otherwise.}
  \item{IRISH}{Dummy variable for ethnicity of respondent: 1 if Irish, 0 otherwise.}
  \item{GERMAN}{Dummy variable for ethnicity of respondent: 1 if German, 0 otherwise.}
  \item{under30}{Dummy variable for age of respondent: 1 if younger than 30 years old, 0 otherwise.}
  \item{mar}{Dummy variable for marital status of respondent: 1 if married, 0 otherwise.}
  \item{usborn}{Dummy variable for place of birth of respondent: 1 if born in the US, 0 otherwise.}
  \item{geometry}{geometry of the simple features object}
}
}
\source{
Páez et al. (2012) \doi{10.1080/00045608.2011.620502}
}
\usage{
data(Newark.sf)
}
\description{
A simple features object with geocoded information about respondents in the 1880 US Census
with selected demographic information coded as dummy variables. The data are projected using
EPSG: 32618 (WGS 84/UTM Zone 18N). The coordinates have been and jiggled to create unique coordinates
for each observation.
}
\examples{
 data(Newark.sf)
 summary(Newark.sf)
}
\references{
\itemize{
    \item Paez, A., Ruiz, M, Lopez, F. & Logan, J. (2012). \emph{Measuring Ethnic Clustering
     and Exposure with the Q Statistic: An Exploratory Analysis of Irish, Germans, and Yankees in 1880 Newark.}. Annals of the Association of American Geographers.
  }
}
\keyword{datasets}
