% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_playlist_list_to_df.R
\name{parse_playlist_list_to_df}
\alias{parse_playlist_list_to_df}
\title{Parse Spotify playlist list to a dataframe}
\usage{
parse_playlist_list_to_df(playlist_list)
}
\arguments{
\item{playlist_list}{List of Spotify playlists, in the format of output from spotifyr::get_user_playlists}
}
\description{
Helper function for spotifyr::get_user_playlists()
}
\examples{
\dontrun{
username <- 'barackobama'
playlist_count <- get_user_playlist_count(username)
num_loops <- ceiling(playlist_count / 50)
offset <- 0

pb <- txtProgressBar(min = 0, max = num_loops, style = 3)

playlist_list <- map(1:ceiling(num_loops), function(this_loop) {
    endpoint <- paste0('https://api.spotify.com/v1/users/', username, '/playlists')
    res <- GET(endpoint, query = list(access_token = get_spotify_access_token(),
                                      offset = offset,
                                      limit = 50)) \%>\% content

    if (!is.null(res$error)) {
        stop(paste0(res$error$message, ' (', res$error$status, ')'))
    }

    content <- res$items

    total <- content$total
    offset <<- offset + 50
    setTxtProgressBar(pb, this_loop)
    return(content)
})

playlist_df <- parse_playlist_list_to_df(playlist_list)
}
}
\keyword{username}
