% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R, R/tidy_glm.R
\name{tidy.spmodel}
\alias{tidy.spmodel}
\alias{tidy.splm}
\alias{tidy.spautor}
\alias{tidy.spglm}
\alias{tidy.spgautor}
\title{Tidy a fitted model object}
\usage{
\method{tidy}{splm}(x, conf.int = FALSE, conf.level = 0.95, effects = "fixed", ...)

\method{tidy}{spautor}(x, conf.int = FALSE, conf.level = 0.95, effects = "fixed", ...)

\method{tidy}{spglm}(x, conf.int = FALSE, conf.level = 0.95, effects = "fixed", ...)

\method{tidy}{spgautor}(x, conf.int = FALSE, conf.level = 0.95, effects = "fixed", ...)
}
\arguments{
\item{x}{A fitted model object from \code{\link[=splm]{splm()}}, \code{\link[=spautor]{spautor()}}, \code{\link[=spglm]{spglm()}}, or \code{\link[=spgautor]{spgautor()}}.}

\item{conf.int}{Logical indicating whether or not to include a confidence interval
in the tidied output. The default is \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval if
\code{conf.int} is \code{TRUE}. Must be strictly greater than 0 and less than 1.
The default is 0.95, which corresponds to a 95 percent confidence interval.}

\item{effects}{The type of effects to tidy. Available options are \code{"fixed"}
(fixed effects), \code{"spcov"} (spatial covariance parameters),
and \code{"randcov"} (random effect variances). The default is \code{"fixed"}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A tidy tibble of summary information \code{effects}.
}
\description{
Tidy a fitted model object into a summarized tibble.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
tidy(spmod)
tidy(spmod, effects = "spcov")
}
\seealso{
\code{\link[=glance.spmodel]{glance.spmodel()}} \code{\link[=augment.spmodel]{augment.spmodel()}}
}
