% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covmatrix.R, R/covmatrix_glm.R
\name{covmatrix}
\alias{covmatrix}
\alias{covmatrix.splm}
\alias{covmatrix.spautor}
\alias{covmatrix.spglm}
\alias{covmatrix.spgautor}
\title{Create a covariance matrix}
\usage{
covmatrix(object, newdata, ...)

\method{covmatrix}{splm}(object, newdata, ...)

\method{covmatrix}{spautor}(object, newdata, ...)

\method{covmatrix}{spglm}(object, newdata, ...)

\method{covmatrix}{spgautor}(object, newdata, ...)
}
\arguments{
\item{object}{A fitted model object (e.g., \code{\link[=splm]{splm()}}, \code{\link[=spautor]{spautor()}}, \code{\link[=spglm]{spglm()}}, or \code{\link[=spgautor]{spgautor()}}).}

\item{newdata}{If omitted, the covariance matrix of
the observed data is returned. If provided, \code{newdata} is
a data frame or \code{sf} object that contains coordinate information
required to construct the covariance between \code{newdata} and
the observed data. If a data frame, \code{newdata}
must contain variables that represent coordinates having the same name as
the coordinates from the observed data used to fit \code{object}. If an
\code{sf} object, coordinates are obtained from the geometry of \code{newdata}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
If \code{newdata} is omitted, the covariance matrix of the observed
data, which has dimension n x n, where n is the sample size used to fit \code{object}.
If \code{newdata} is provided, the covariance matrix between the unobserved (new)
data and the observed data, which has dimension m x n, where m is the number of
new observations and n is the sample size used to fit \code{object}.
}
\description{
Create a covariance matrix from a fitted model object.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
covmatrix(spmod)
}
